package com.elitesland.tw.tw5crm.server.sale.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Entity
@Table(name = "crm_exam_information", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_exam_information", comment = "sale")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ExamInformationDO extends BaseModel implements Serializable  {
    /** 主表主键 crm_sale_goal.goal_id */
    @Comment("主表主键 crm_sale_goal.id")
    @Column()
    private Long goalId;
    /** udc[crm:target:exam_target](线索数A(个)、商机金额B(元)、客户数(个)、合同额(元)、拜访数(个)) */
    @Comment("udc[crm:target:exam_target](线索数A(个)、商机金额B(元)、客户数(个)、合同额(元)、拜访数(个))")
    @Column()
    private String examTarget;
    /** 筛选字段key */
    @Comment("筛选字段key")
    @Column()
    private String fieldKey;
    /** 筛选字段名称 */
    @Comment("筛选字段名称")
    @Column()
    private String fieldName;
    /** 搜索类型 */
    @Comment("搜索类型")
    @Column()
    private String searchType;
    /** 搜索范围 */
    @Comment("搜索范围")
    @Column()
    private String searchScope;
    /** 搜索条件,多个条件以英文逗号隔开 */
    @Comment("搜索条件,多个条件以英文逗号隔开")
    @Column()
    private String searchCondition;
    /** 设置项KEY */
    @Comment("设置项KEY")
    @Column()
    private String settingKey;
    /** 设置项名称 */
    @Comment("设置项名称")
    @Column()
    private String settingName;
    /** 设置项值 */
    @Comment("设置项值")
    @Column()
    private String settingValue;
    /** 拓展字段1 */
    @Comment("拓展字段1 搜索条件name,多个条件以英文逗号隔开")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ExamInformationDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
