package com.elitesland.tw.tw5crm.server.sale.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Entity
@Table(name = "crm_sale_goal", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_sale_goal", comment = "sale")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SaleGoalDO extends BaseModel implements Serializable  {
    /** 主目标名称 */
    @Comment("主目标名称")
    @Column()
    private String goalName;
    /** 统计财年 */
    @Comment("统计财年")
    @Column()
    private Integer fiscalYear;
    /** 主目标负责人主键 prd_org_employee.user_id */
    @Comment("主目标负责人主键 prd_org_employee.user_id")
    @Column()
    private Long dutyId;
    /** 主目标负责人姓名 prd_org_employee.employee_name */
    @Comment("主目标负责人姓名 prd_org_employee.employee_name")
    @Column()
    private String dutyName;
    /** udc[crm:goal_type](人员目标、客户目标、产品目标) */
    @Comment("udc[crm:goal_type](人员目标、客户目标、产品目标)")
    @Column()
    private String goalType;
    /** udc[crm:target:exam_target](线索数(个)、商机金额(元)、客户数(个)、合同额(元)、拜访数(个)) */
    @Comment("udc[crm:target:exam_target](线索数(个)、商机金额(元)、客户数(个)、合同额(元)、拜访数(个))")
    @Column()
    private String examTarget;
    /** 目标总值 */
    @ApiModelProperty("目标总值")
    private BigDecimal targetCount;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(SaleGoalDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
