package com.elitesland.tw.tw5crm.server.sale.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Entity
@Table(name = "crm_sale_target", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_sale_target", comment = "sale")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SaleTargetDO extends BaseModel implements Serializable  {
    /** 主表主键 crm_sale_goal.goal_id */
    @Comment("主表主键 crm_sale_goal.id")
    @Column()
    private Long goalId;
    /** 上级目标ID */
    @Comment("上级目标ID")
    @Column()
    private Long parentId;
    /** 目标名称 */
    @Comment("目标名称")
    @Column()
    private String goalName;
    /** 统计财年 crm_sale_goal.fiscal_year(冗余) */
    @Comment("统计财年 crm_sale_goal.fiscal_year(冗余)")
    @Column()
    private Integer fiscalYear;
    /** 第一季度目标值 */
    @Comment("第一季度目标值")
    @Column()
    private BigDecimal firstQuarter;
    /** 第二季度目标值 */
    @Comment("第二季度目标值")
    @Column()
    private BigDecimal secondQuarter;
    /** 第三季度目标值 */
    @Comment("第三季度目标值")
    @Column()
    private BigDecimal thirdQuarter;
    /** 第四季度目标值 */
    @Comment("第四季度目标值")
    @Column()
    private BigDecimal forthQuarter;
    /** 一月目标值 */
    @Comment("一月目标值")
    @Column()
    private BigDecimal january;
    /** 二月目标值 */
    @Comment("二月目标值")
    @Column()
    private BigDecimal february;
    /** 三月目标值 */
    @Comment("三月目标值")
    @Column()
    private BigDecimal march;
    /** 四月目标值 */
    @Comment("四月目标值")
    @Column()
    private BigDecimal april;
    /** 五月目标值 */
    @Comment("五月目标值")
    @Column()
    private BigDecimal may;
    /** 六月目标值 */
    @Comment("六月目标值")
    @Column()
    private BigDecimal june;
    /** 七月目标值 */
    @Comment("七月目标值")
    @Column()
    private BigDecimal july;
    /** 八月目标值 */
    @Comment("八月目标值")
    @Column()
    private BigDecimal august;
    /** 九月目标值 */
    @Comment("九月目标值")
    @Column()
    private BigDecimal september;
    /** 十月目标值 */
    @Comment("十月目标值")
    @Column()
    private BigDecimal october;
    /** 十一月目标值 */
    @Comment("十一月目标值")
    @Column()
    private BigDecimal november;
    /** 十二月目标值 */
    @Comment("十二月目标值")
    @Column()
    private BigDecimal december;
    /** 目标总值 */
    @Comment("目标总值")
    @Column()
    private BigDecimal targetCount;
    /** udc[crm:goal_type](人员目标、客户目标、产品目标) */
    @Comment("udc[crm:goal_type](人员目标、客户目标、产品目标)")
    @Column()
    private String goalType;
    /** 目标负责人主键 prd_org_employee.user_id */
    @Comment("目标负责人主键 prd_org_employee.user_id")
    @Column()
    private Long dutyId;
    /** 目标负责人姓名  prd_org_employee.employee_name */
    @Comment("目标负责人姓名  prd_org_employee.employee_name")
    @Column()
    private String dutyName;
    /** 产品主键 crm_product_sku.id */
    @Comment("产品主键 crm_product_sku.id")
    @Column()
    private Long skuId;
    /** 产品名称 crm_product_sku.sku_name */
    @Comment("产品名称 crm_product_sku.sku_name")
    @Column()
    private String skuName;
    /** 产品主键 crm_product_spu.id */
    @Comment("spu主键 crm_product_spu.id")
    @Column()
    private Long spuId;
    /** spu名称 crm_product_spu.spu_name */
    @Comment("spu名称 crm_product_spu.spu_name")
    @Column()
    private String spuName;
    /** 客户主键 crm_customer.id */
    @Comment("客户主键 crm_customer.id")
    @Column()
    private Long customerId;
    /** 客户名称  crm_customer.customer_name */
    @Comment("客户名称  crm_customer.customer_name")
    @Column()
    private String customerName;
    /** 目标类型主键 */
    @Comment("目标类型主键")
    @Column()
    private Long objId;
    /** 目标类型名称 */
    @Comment("目标类型名称")
    @Column()
    private String objName;
    /** 拓展字段1 */
    @Comment("是否为叶子节点")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(SaleTargetDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
