package com.elitesland.tw.tw5crm.server.sale.service;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.server.sale.repo.ExamInformationRepo;
import com.elitesland.tw.tw5crm.server.sale.dao.ExamInformationDAO;
import com.elitesland.tw.tw5crm.server.sale.convert.ExamInformationConvert;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.server.sale.entity.ExamInformationDO;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;

import java.util.*;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ExamInformationServiceImpl extends BaseServiceImpl implements ExamInformationService {

    private final ExamInformationRepo examInformationRepo;
    private final ExamInformationDAO examInformationDAO;

    @Override
    public PagingVO<ExamInformationVO> paging(ExamInformationQuery query){
        Page<ExamInformationDO> page = examInformationRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(ExamInformationConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<ExamInformationVO> queryPaging(ExamInformationQuery query){
        return examInformationDAO.queryPaging(query);
    }

    @Override
    public List<ExamInformationVO> queryList(ExamInformationQuery query){
        return ExamInformationConvert.INSTANCE.toVoList(
                examInformationRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
             )
        );
    }

    @Override
    public List<ExamInformationVO> queryListDynamic(ExamInformationQuery query){
        if (query.getGoalId() == null) {
            throw TwException.error("", "goalId不能为空");
        }
        return examInformationDAO.queryListDynamic(query);
    }

    @Override
    public ExamInformationVO queryByKey(Long key) {
        ExamInformationDO entity = examInformationRepo.findById(key).orElseGet(ExamInformationDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ExamInformationVO vo = ExamInformationConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ExamInformationVO insert(ExamInformationPayload payload) {
        ExamInformationDO entityDo = ExamInformationConvert.INSTANCE.toDo(payload);
        return ExamInformationConvert.INSTANCE.toVo(examInformationRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ExamInformationVO update(ExamInformationPayload payload) {
        ExamInformationDO entity = examInformationRepo.findById(payload.getId()).orElseGet(ExamInformationDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ExamInformationDO entityDo = ExamInformationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ExamInformationConvert.INSTANCE.toVo(examInformationRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ExamInformationDO> optional = examInformationRepo.findById(id);
                if (!optional.isEmpty()) {
                    ExamInformationDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    examInformationRepo.save(entity);
                }
             });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByGoalId(Long goalId) {
        examInformationDAO.deleteSoftByGoalId(goalId);
    }

}
