package com.elitesland.tw.tw5crm.server.sale.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSpuVO;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleGoalPayload;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleGoalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5crm.api.sale.service.SaleGoalService;
import com.elitesland.tw.tw5crm.api.sale.service.SaleTargetService;
import com.elitesland.tw.tw5crm.api.sale.vo.*;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetExamTargetEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetSaleGoalTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetStatisticalEnum;
import com.elitesland.tw.tw5crm.server.sale.convert.ExamInformationConvert;
import com.elitesland.tw.tw5crm.server.sale.convert.SaleGoalConvert;
import com.elitesland.tw.tw5crm.server.sale.convert.SaleTargetConvert;
import com.elitesland.tw.tw5crm.server.sale.dao.SaleGoalDAO;
import com.elitesland.tw.tw5crm.server.sale.entity.ExamInformationDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.repo.ExamInformationRepo;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleGoalRepo;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleTargetRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleGoalServiceImpl extends BaseServiceImpl implements SaleGoalService {

    private final SaleGoalRepo saleGoalRepo;
    private final SaleGoalDAO saleGoalDAO;
    private final ExamInformationService examInformationService;
    private final SaleTargetRepo saleTargetRepo;
    private final SaleTargetService saleTargetService;
    private final ExamInformationRepo examInformationRepo;
    private final CacheUtil cacheUtil;
    private final ProductSpuService productSpuService;
    private final ProductSkuService productSkuService;
    private final CrmCustomerService crmCustomerService;

    /**
     * 销售目标统计
     *
     * @param query 查询
     * @return {@link List}<{@link SaleTargetDualVO}>
     */
    @Override
    public SaleTargetStatisticalVO saleTargetStatistical(SaleTargetStatisticalQuery query) {
        SaleTargetStatisticalVO result = new SaleTargetStatisticalVO();
        final Long goalId = query.getGoalId();
        // 返回结果
        List<SaleTargetDualVO> resultList = new ArrayList<>();
        if (null == goalId) {
            throw TwException.error("", "goalId不能为空");
        }
        SaleGoalDO entity = saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull(entity.getId(), "销售目标不存在");

        // 默认统计时间区间
        final Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of(fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of(fiscalYear, 12, 31, 23, 59, 59));
        }
        //SaleTargetQuery targetQuery = new SaleTargetQuery();
        //targetQuery.setGoalId(goalId);
        //targetQuery.setExt1("true");
        // 查询最底层的额定目标
        //final List<SaleTargetVO> saleTargetVOList = saleTargetService.queryListDynamic(targetQuery);
        List<SaleTargetVO> saleTargetVOList = saleGoalDAO.countSaleTarget(goalId, "true", query.getOrgId(), query.getUserId(),query.getCustIndustry(),query.getCustomerGrade());
        if (null == query.getUserId()) {
            final Set<Long> userIds = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
            query.setUserIds(userIds);
        }
        Map<String, BigDecimal> map = new HashMap();
        saleTargetVOList.forEach(saleTargetVO -> {

            SaleTargetDualVO saleTargetDualVO = new SaleTargetDualVO();
            saleTargetDualVO.setType(SaleTargetStatisticalEnum.TARGET.getDesc());
            if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
                // 月目标值 数据转换
                monthDataConversion(map, saleTargetVO);
            } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
                // 月目标值 数据转换
                quarterDataConversion(map, saleTargetVO);
            }

        });
        Iterator<Map.Entry<String, BigDecimal>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BigDecimal> next = iterator.next();
            //next.getKey();// 月份
            //next.getValue();// 目标值
            //System.out.println("key="+next.getKey()+"value="+next.getValue());
            resultList.add(new SaleTargetDualVO(next.getKey(), next.getValue(), SaleTargetStatisticalEnum.TARGET.getDesc()));
        }

        // 待统计实际完成值的 人列表
        final Set<Long> userIdSet = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
        query.setUserIds(userIdSet);

        // 规则
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        final List<ExamInformationVO> examInformationVOList = examInformationService.queryListDynamic(examInformationQuery);
        query.setExamInformationVOList(examInformationVOList);
        // 根据规则 去拉取实际完成值
        // udc[crm:goal_type](人员目标、客户目标、产品目标)
        String goalType = entity.getGoalType();
        // udc[crm:target:exam_target](线索数(个)、商机金额(元)、客户数(个)、合同额(元)、拜访数(个))
        String examTarget = entity.getExamTarget();

        List<SaleTargetDualVO> saleTargetDualVOS = new ArrayList<>();
        // 人员目标
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                // 销售拜访任务
                saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                // 线索数
                saleTargetDualVOS = saleGoalDAO.countLeadsByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                // 商机金额
                saleTargetDualVOS = saleGoalDAO.countOppoByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CONTRACT.getCode())) {
                // 合同额
                //saleTargetDualVOS = saleGoalDAO.countOppoByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) {
                // 客户数
                saleTargetDualVOS = saleGoalDAO.countCustomerByExamInformation(query);
            }
        } // 产品目标
        else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
            // 根据规则 去查询实际完成值
            if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_SALE.getCode())) {
                // 销售量(个)
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_CONTRACT.getCode())) {
                // 合同额
            }
        }
        //客户目标
        else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            // 根据规则 去查询实际完成值
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
                // 销售拜访任务
                saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_CONTRACT.getCode())) {
                // 合同额
                //saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_PAYMENT.getCode())) {
                // 回款额
                //saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
            }
        }
        // 目标值、完成值数据处理
        visitDataProcess(resultList, map, saleTargetDualVOS);
        result.setSaleTargetDualVOList(resultList);

        // 比例数据
        List<SaleTargetDualRateVO> saleTargetDualRateVOList = new ArrayList<>();
        resultList.stream().map(saleTargetDualVO -> saleTargetDualVO.getTime()).distinct()
                .forEach(time ->{
                    AtomicReference<BigDecimal> targetValue = new AtomicReference<>(BigDecimal.ONE);
                    AtomicReference<BigDecimal> actualValue = new AtomicReference<>(BigDecimal.ZERO);
                    resultList.forEach(saleTargetDualVO -> {
                        final String voTime = saleTargetDualVO.getTime();
                        if (voTime.equals(time) && saleTargetDualVO.getType().equals(SaleTargetStatisticalEnum.TARGET.getDesc())) {
                            if (saleTargetDualVO.getValue().compareTo(BigDecimal.ZERO) !=0) {
                                targetValue.set(saleTargetDualVO.getValue());
                            }
                        }
                        if (voTime.equals(time) && saleTargetDualVO.getType().equals(SaleTargetStatisticalEnum.COMPLETE.getDesc())) {
                            actualValue.set(saleTargetDualVO.getValue());
                        }
                    });
                    final BigDecimal rate = actualValue.get().divide(targetValue.get(), 4, RoundingMode.HALF_UP);
                    saleTargetDualRateVOList.add(new SaleTargetDualRateVO(time, rate));
                });
        result.setSaleTargetDualRateVOList(saleTargetDualRateVOList);
        return result;
    }

    private void visitDataProcess(List<SaleTargetDualVO> resultList, Map<String, BigDecimal> map, List<SaleTargetDualVO> saleTargetDualVOS) {
        Iterator<Map.Entry<String, BigDecimal>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BigDecimal> next = iterator.next();
            //next.getKey();// 月份
            //next.getValue();// 目标值
            //System.out.println("key="+next.getKey()+"value="+next.getValue());
            final String time = next.getKey();
            SaleTargetDualVO actual = new SaleTargetDualVO(time, BigDecimal.ZERO, SaleTargetStatisticalEnum.COMPLETE.getDesc());
            saleTargetDualVOS.forEach(saleTargetDualVO -> {
                if (saleTargetDualVO.getTime().equals(time)) {
                    actual.setValueLong(saleTargetDualVO.getValueLong());
                }
            });
            resultList.add(actual);
        }
    }

    /**
     * 季度维度 目标值 数据转换
     *
     * @param map          集合
     * @param saleTargetVO 销售目标
     */
    public static void quarterDataConversion(Map<String, BigDecimal> map, SaleTargetVO saleTargetVO) {
        //String suffix = "季度";
        String suffix = "";
        BigDecimal firstQuarter = map.get("1" + suffix);
        firstQuarter = firstQuarter == null ? BigDecimal.ZERO : firstQuarter;
        map.put("1" + suffix, firstQuarter.add(saleTargetVO.getFirstQuarter()));

        BigDecimal secondQuarter = map.get("2" + suffix);
        secondQuarter = secondQuarter == null ? BigDecimal.ZERO : secondQuarter;
        map.put("2" + suffix, secondQuarter.add(saleTargetVO.getSecondQuarter()));

        BigDecimal thirdQuarter = map.get("3" + suffix);
        thirdQuarter = thirdQuarter == null ? BigDecimal.ZERO : thirdQuarter;
        map.put("3" + suffix, thirdQuarter.add(saleTargetVO.getThirdQuarter()));

        BigDecimal forthQuarter = map.get("4" + suffix);
        forthQuarter = forthQuarter == null ? BigDecimal.ZERO : forthQuarter;
        map.put("4" + suffix, forthQuarter.add(saleTargetVO.getForthQuarter()));

    }

    /**
     * 月维度 目标值 数据转换
     *
     * @param map          集合
     * @param saleTargetVO 销售目标
     */
    public static void monthDataConversion(Map<String, BigDecimal> map, SaleTargetVO saleTargetVO) {
        BigDecimal january = map.get("01月");
        january = january == null ? BigDecimal.ZERO : january;
        map.put("01月", january.add(saleTargetVO.getJanuary()));

        BigDecimal february = map.get("02月");
        february = february == null ? BigDecimal.ZERO : february;
        map.put("02月", february.add(saleTargetVO.getFebruary()));

        BigDecimal march = map.get("03月");
        march = march == null ? BigDecimal.ZERO : march;
        map.put("03月", march.add(saleTargetVO.getMarch()));

        BigDecimal april = map.get("04月");
        april = april == null ? BigDecimal.ZERO : april;
        map.put("04月", april.add(saleTargetVO.getApril()));

        BigDecimal may = map.get("05月");
        may = may == null ? BigDecimal.ZERO : may;
        map.put("05月", may.add(saleTargetVO.getMay()));

        BigDecimal june = map.get("06月");
        june = june == null ? BigDecimal.ZERO : june;
        map.put("06月", june.add(saleTargetVO.getJune()));

        BigDecimal july = map.get("07月");
        july = july == null ? BigDecimal.ZERO : july;
        map.put("07月", july.add(saleTargetVO.getJuly()));

        BigDecimal august = map.get("08月");
        august = august == null ? BigDecimal.ZERO : august;
        map.put("08月", august.add(saleTargetVO.getAugust()));

        BigDecimal september = map.get("09月");
        september = september == null ? BigDecimal.ZERO : september;
        map.put("09月", september.add(saleTargetVO.getSeptember()));

        BigDecimal october = map.get("10月");
        october = october == null ? BigDecimal.ZERO : october;
        map.put("10月", october.add(saleTargetVO.getOctober()));

        BigDecimal november = map.get("11月");
        november = november == null ? BigDecimal.ZERO : november;
        map.put("11月", november.add(saleTargetVO.getNovember()));

        BigDecimal december = map.get("12月");
        december = december == null ? BigDecimal.ZERO : december;
        map.put("12月", december.add(saleTargetVO.getDecember()));
    }

    @Override
    public PagingVO<SaleGoalVO> queryPaging(SaleGoalQuery query) {
        // 数据权限处理
        dataPermissionFlag(query);
        PagingVO<SaleGoalVO> goalVOPagingVO = saleGoalDAO.queryPaging(query);
        List<SaleGoalVO> records = goalVOPagingVO.getRecords();
        records.forEach(saleGoalVO -> {
            // 完成值数据处理 考核规格
            getExamInformationList(saleGoalVO, true);
            // 明细
//            getSaleTargetList(saleGoalVO);
            translate(saleGoalVO);
        });
        return goalVOPagingVO;
    }

    /**
     * 权限处理
     * @param query
     */
    void dataPermissionFlag(SaleGoalQuery query) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            //需要处理权限
            Long userId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(userId);
        }
    }

    /**
     * 翻译
     * @param saleGoalVO
     */
    private void translate(SaleGoalVO saleGoalVO) {
        String goalType = saleGoalVO.getGoalType();
        // 人员目标
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            saleGoalVO.setExamTargetDesc(cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.USER.getCode(), saleGoalVO.getExamTarget()));
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            //客户目标
            saleGoalVO.setExamTargetDesc(cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), saleGoalVO.getExamTarget()));
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
            //客户目标
            saleGoalVO.setExamTargetDesc(cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), saleGoalVO.getExamTarget()));
        }
    }

    /**
     * 得到销售目标明细列表
     *
     * @param saleGoalVO
     */
    private void getSaleTargetList(SaleGoalVO saleGoalVO) {
        SaleTargetQuery saleTargetQuery = new SaleTargetQuery();
        saleTargetQuery.setGoalId(saleGoalVO.getId());
        List<SaleTargetVO> saleTargetVOS = saleTargetService.queryList(saleTargetQuery);
        saleGoalVO.setSaleTargetVOList(saleTargetVOS);
    }

    /**
     * 获取考核规则列表
     *
     * @param saleGoalVO 销售目标签证官
     */
    private void getExamInformationList(SaleGoalVO saleGoalVO, boolean isPaging) {
        // 规则
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        Long goalId = saleGoalVO.getId();
        examInformationQuery.setGoalId(goalId);
        List<ExamInformationVO> examInformationVOS = examInformationService.queryListDynamic(examInformationQuery);
        if (isPaging) {
            // 根据规则 去拉取实际完成值
            final String goalType = saleGoalVO.getGoalType();
            final String examTarget = saleGoalVO.getExamTarget();
            Set<Long> userIds = new HashSet<>();
            userIds.add(111222L);
            List<SaleTargetVO> saleTargetVOList = saleGoalDAO.countSaleTarget(saleGoalVO.getId(), "true", null, null,null,null);
            Set<Long> userIdsTarget = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(userIdsTarget)) {
                userIds = userIdsTarget;
            }
            // 默认统计时间区间
            final Integer fiscalYear = saleGoalVO.getFiscalYear();
            LocalDateTime startTime = LocalDateTime.of(fiscalYear, 1, 1, 0, 0, 0);
            LocalDateTime endTime = LocalDateTime.of(fiscalYear, 12, 31, 23, 59, 59);
            // 人员目标
            if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                    // 销售拜访任务
                    long visitCount = saleGoalDAO.countVisitByExamInformation(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(visitCount));
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                    // 线索数
                    long count = saleGoalDAO.countLeadsByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(count));
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                    // 商机金额
                    BigDecimal sum = saleGoalDAO.countOppoByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(sum);
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_CONTRACT.getCode())) {
                    // 合同额
                    //saleTargetDualVOS = saleGoalDAO.countOppoByExamInformation(query);
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) {
                    // 客户数
                    long count =  saleGoalDAO.countCustomerByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(count));
                }
            } // 产品目标
            else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                // 根据规则 去查询实际完成值
                if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_SALE.getCode())) {
                    // 销售量(个)
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_CONTRACT.getCode())) {
                    // 合同额
                }
            }
            //客户目标
            else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
                // 根据规则 去查询实际完成值
                if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
                    // 销售拜访任务
                    long visitCount = saleGoalDAO.countVisitByExamInformation(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(visitCount));
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_CONTRACT.getCode())) {
                    // 合同额
                    //saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_PAYMENT.getCode())) {
                    // 回款额
                    //saleTargetDualVOS = saleGoalDAO.countVisitTaskByExamInformation(query);
                }
            }
        } else {
            // 翻译udc
            translate(examInformationVOS, saleGoalVO);

            saleGoalVO.setExamInformationVOList(examInformationVOS);
        }

    }

    /**
     * 考核指标明细翻译
     *
     * @param examInformationVOS 考试信息vos
     * @param saleGoalVO         销售目标签证官
     */
    private void translate(List<ExamInformationVO> examInformationVOS, SaleGoalVO saleGoalVO) {

        if (null != saleGoalVO && !CollectionUtils.isEmpty(examInformationVOS)) {

            String goalType = saleGoalVO.getGoalType();
            examInformationVOS.forEach(examInformationVO -> {
                // 人员目标
                if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.USER.getCode(), examInformationVO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));

                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
                    //客户目标
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), examInformationVO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                    //客户目标
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), examInformationVO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));
                }
                if (ObjectUtils.isEmpty(examInformationVO.getExt1())) {
                    // 规则映射
                    final PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj("crm:rule_map", examInformationVO.getFieldKey());
                    if (null != prdSystemSelectionVO) {
                        // udc
                        final String udcKey = prdSystemSelectionVO.getExtString2();
                        examInformationVO.setSettingKey(udcKey);
                        examInformationVO.setSettingName(prdSystemSelectionVO.getSelectionName());
                        //examInformationDO.setSettingValue();
                        if (StringUtils.hasText(udcKey)) {
                            final String searchCondition = examInformationVO.getSearchCondition();
                            if (StringUtils.hasText(searchCondition)) {
                                final String[] values = searchCondition.split(",");
                                List<String> udcNames = new ArrayList<>();
                                for (String value : values) {
                                    udcNames.add(cacheUtil.transferSystemSelection(udcKey, value));
                                }
                                final String udcNamesStr = udcNames.stream().collect(Collectors.joining(","));
                                examInformationVO.setExt1(udcNamesStr);
                            } else {
                                log.warn("值不存在");
                            }
                        } else {
                            log.warn("规格映射配置有问题；examInformationDO.getFieldKey()：{}", examInformationVO.getFieldKey());
                        }
                    }
                }

            });

        }

    }

    @Override
    public List<SaleGoalVO> queryListDynamic(SaleGoalQuery query) {
        return saleGoalDAO.queryListDynamic(query);
    }

    @Override
    public SaleGoalVO queryByKey(Long key) {
        SaleGoalDO entity = saleGoalRepo.findById(key).orElseGet(SaleGoalDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SaleGoalVO vo = SaleGoalConvert.INSTANCE.toVo(entity);
        // 翻译
        translate(vo);
        // 考核规格
        getExamInformationList(vo, false);
        // 明细
        getSaleTargetList(vo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleGoalVO insert(SaleGoalPayload payload) {
        SaleGoalDO saleGoalDO = SaleGoalConvert.INSTANCE.toDo(payload);
        SaleGoalDO save = saleGoalRepo.save(saleGoalDO);
        //保存考核信息
        saveExamData(payload, saleGoalDO);
        //保存销售目标明细
        saveTargetData(payload, saleGoalDO);
        return SaleGoalConvert.INSTANCE.toVo(save);
    }

    /**
     * 保存销售目标明细
     *
     * @param payload
     * @param saleGoalDO
     */
    void saveTargetData(SaleGoalPayload payload, SaleGoalDO saleGoalDO) {
        Long goalId = saleGoalDO.getId();
        // 删除的明细
        saleTargetService.deleteSoftByGoalId(goalId);
        // 新增、修改明细
        List<SaleTargetPayload> saleTargetPayloads = payload.getSaleTargetList();
        if (!ObjectUtils.isEmpty(saleTargetPayloads)) {
            List<SaleTargetDO> saleTargetDOS = new ArrayList<>();
            // 第一级
            List<SaleTargetDO> saleTargetDOSOneLevel = new ArrayList<>();
            saleTargetPayloads.forEach(saleTargetPayload -> {
                SaleTargetDO saleTargetDO = SaleTargetConvert.INSTANCE.toDo(saleTargetPayload);
                Long skuId = saleTargetDO.getSkuId();
                if (skuId != null) {
                    ProductSkuVO productSkuVO = productSkuService.queryByKey(skuId);
                    saleTargetDO.setSkuName(productSkuVO.getSkuName());
                    Long spuId = productSkuVO.getSpuId();
                    saleTargetDO.setSpuId(spuId);
                    ProductSpuVO productSpuVO = productSpuService.queryByKey(spuId);
                    saleTargetDO.setSpuName(productSpuVO.getSpuName());
                }
                Long customerId = saleTargetDO.getCustomerId();
                if (customerId != null) {
                    CrmCustomerSimpleVO crmCustomerSimpleVO = crmCustomerService.querySimpleByKey(customerId);
                    saleTargetDO.setCustomerName(crmCustomerSimpleVO.getCustomerName());
                }
                saleTargetDO.setGoalId(saleGoalDO.getId());
                saleTargetDO.setFiscalYear(saleGoalDO.getFiscalYear());
                saleTargetDO.setGoalType(saleGoalDO.getGoalType());
                saleTargetDO.setFirstQuarter(saleTargetDO.getJanuary().add(saleTargetDO.getFebruary().add(saleTargetDO.getMarch())));
                saleTargetDO.setSecondQuarter(saleTargetDO.getApril().add(saleTargetDO.getMay().add(saleTargetDO.getJune())));
                saleTargetDO.setThirdQuarter(saleTargetDO.getJuly().add(saleTargetDO.getAugust().add(saleTargetDO.getSeptember())));
                saleTargetDO.setForthQuarter(saleTargetDO.getOctober().add(saleTargetDO.getNovember().add(saleTargetDO.getDecember())));
                if (saleTargetPayload.getId().equals(0L) || saleTargetPayload.getParentId() == null) {
                    saleTargetDOSOneLevel.add(saleTargetDO);
                } else {
                    saleTargetDOS.add(saleTargetDO);
                }
            });
            // 按层级保存
            cascadeSave(saleTargetDOS, saleTargetDOSOneLevel, 0L);
        }
    }


    /**
     * 级联保存
     *
     * @param saleTargetDOS         销售目标dos
     * @param saleTargetDOSOneLevel 销售目标父目标
     */
    private void cascadeSave(List<SaleTargetDO> saleTargetDOS, List<SaleTargetDO> saleTargetDOSOneLevel, Long parentDbId) {
        saleTargetDOSOneLevel.forEach(parent -> {
            if (parentDbId.equals(0L)) {
                parent.setParentId(null);
            } else {
                parent.setParentId(parentDbId);
            }
            final SaleTargetDO save = saleTargetRepo.save(parent);
            final Long parentId = save.getId();
            final List<SaleTargetDO> childrenList = saleTargetDOS.stream()
                // parent.getId() 前端给的标记 判断层级关系
                .filter(saleTargetDO -> saleTargetDO.getParentId().equals(parent.getId()))
                .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(childrenList)) {
                cascadeSave(saleTargetDOS, childrenList, parentId);
            }
        });
    }

    /**
     * 保存考核信息
     *
     * @param payload
     * @param saleGoalDO
     */
    void saveExamData(SaleGoalPayload payload, SaleGoalDO saleGoalDO) {
        // 全部清空再插入
        Long goalId = saleGoalDO.getId();
        String goalType = saleGoalDO.getGoalType();
        examInformationService.deleteSoftByGoalId(goalId);

        //规则新增、编辑
        List<ExamInformationPayload> examInformationPayloads = payload.getExamInformationList();
        if (!ObjectUtils.isEmpty(examInformationPayloads)) {
            List<ExamInformationDO> examInformationDOS = new ArrayList<>();
            examInformationPayloads.forEach(examInformationPayload -> {
                ExamInformationDO examInformationDO = ExamInformationConvert.INSTANCE.toDo(examInformationPayload);
                examInformationDO.setGoalId(goalId);
                examInformationDO.setExamTarget(saleGoalDO.getExamTarget());

                // 人员目标
                if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.USER.getCode(), examInformationDO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    //String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationDO.setFieldName(cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));

                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
                    //客户目标
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), examInformationDO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    //String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationDO.setFieldName(cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                    //客户目标
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), examInformationDO.getExamTarget());
                    String key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    //String desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationDO.setFieldName(cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));
                }
                // 规则映射
                final PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj("crm:rule_map", examInformationDO.getFieldKey());
                if (null != prdSystemSelectionVO) {
                    // udc
                    final String udcKey = prdSystemSelectionVO.getExtString2();
                    examInformationDO.setSettingKey(udcKey);
                    examInformationDO.setSettingName(prdSystemSelectionVO.getSelectionName());
                    //examInformationDO.setSettingValue();
                    if (StringUtils.hasText(udcKey)) {
                        final String searchCondition = examInformationDO.getSearchCondition();
                        if (StringUtils.hasText(searchCondition)) {
                            final String[] values = searchCondition.split(",");
                            List<String> udcNames = new ArrayList<>();
                            for (String value : values) {
                                udcNames.add(cacheUtil.transferSystemSelection(udcKey, value));
                            }
                            final String udcNamesStr = udcNames.stream().collect(Collectors.joining(","));
                            examInformationDO.setExt1(udcNamesStr);
                        } else {
                            log.warn("值不存在");
                        }
                    } else {
                        log.warn("规格映射配置有问题；examInformationDO.getFieldKey()：{}", examInformationDO.getFieldKey());
                    }
                }
                examInformationDOS.add(examInformationDO);
            });
            examInformationRepo.saveAll(examInformationDOS);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleGoalVO update(SaleGoalPayload payload) {
        SaleGoalDO entity = saleGoalRepo.findById(payload.getId()).orElseGet(SaleGoalDO::new);
        if (payload.getId() == null) {
            throw TwException.error("1", "销售目标id不存在");
        }
        //权限
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        Long userId = GlobalUtil.getLoginUserId();
        //只有创建人可以修改
        if (!rolePermission){
            SaleGoalVO saleGoalVO = saleGoalDAO.queryByKey(payload.getId());
            if (!userId.equals(saleGoalVO.getCreateUserId())) {
                throw TwException.error("1", "只有创建人可以修改，当前登陆用户不是创建人");
            }
        }
        //只有主目标负责人可以修改销售目标
//        SaleTargetVO saleTargetVO=saleTargetDAO.queryByKey(payload.getId());
//        if (null==saleTargetVO.getParentId()&&!userId.equals(saleTargetVO.getDutyId())) {
//            throw TwException.error(" ", "只有主目标负责人可以修改销售目标，当前登陆用户不是主目标负责人");
//        }
            SaleGoalDO entityDo = SaleGoalConvert.INSTANCE.toDo(payload);
            entity.copy(entityDo);
            SaleGoalDO saleGoalDO = saleGoalRepo.save(entity);
            //保存销售目标明细
            saveTargetData(payload, saleGoalDO);
            //保存考核信息
            saveExamData(payload, saleGoalDO);
            return SaleGoalConvert.INSTANCE.toVo(saleGoalDO);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {

        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
//                SaleGoalVO saleGoalVO = saleGoalDAO.queryByKey(id);
//                if (!saleGoalVO.getCreateUserId().equals(GlobalUtil.getLoginUserId())) {
//                    throw TwException.error("1", "只有创建人可以删除，当前登陆用户不是创建人");
//                }
                Optional<SaleGoalDO> optional = saleGoalRepo.findById(id);
                if (!optional.isEmpty()) {
                    SaleGoalDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    saleGoalRepo.save(entity);
                }
            });
        }
    }

}
