package com.elitesland.tw.tw5crm.server.tenant.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.tenant.payload.TwTenantPayload;
import com.elitesland.tw.tw5crm.api.tenant.query.TwTenantQuery;
import com.elitesland.tw.tw5crm.api.tenant.service.TwTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * Tw租户管理
 *
 * @author duwh
 * @date 2023-04-06
 */
@Api(tags = "Tw租户管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/tenant/twTenant")
@Slf4j
public class TwTenantController {

    private final TwTenantService twTenantService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody TwTenantPayload payload){
        return TwOutputUtil.ok(twTenantService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody TwTenantPayload payload){
        return TwOutputUtil.ok(twTenantService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(twTenantService.queryByKey(key));
    }

    /**
     * 初始化数据
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/init/{key}")
    @ApiOperation("初始化数据")
    public TwOutputUtil init(@PathVariable Long key) {
        return TwOutputUtil.ok(twTenantService.init(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(TwTenantQuery query) {
        return TwOutputUtil.ok(twTenantService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(TwTenantQuery query) {
        return TwOutputUtil.ok(twTenantService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        twTenantService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
