package com.elitesland.tw.tw5crm.server.tenant.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Tw租户管理
 *
 * @author duwh
 * @date 2023-04-06
 */
@Entity
@Table(name = "tw_tenant", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "tw_tenant", comment = "Tw租户管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TwTenantDO extends BaseModel implements Serializable  {
    /** 租户编码 */
    @Comment("租户编码")
    @Column()
    private String tenantCode;
    /** 租户名称 */
    @Comment("租户名称")
    @Column()
    private String tenantName;
    /** 管理员的用户ID */
    @Comment("管理员的用户ID")
    @Column()
    private Long adminUserId;
    /** 租户类型 */
    @Comment("租户类型")
    @Column()
    private String tenantType;
    /** 是否初始化 */
    @Comment("是否初始化")
    @Column()
    private Boolean inited;
    /** 是否启用 */
    @Comment("是否启用")
    @Column()
    private Boolean enabled;
    /** 联系人 */
    @Comment("联系人")
    @Column()
    private String linkman;
    /** 联系电话 */
    @Comment("联系电话")
    @Column()
    private String contactNumber;
    /** 联系地址 */
    @Comment("联系地址")
    @Column()
    private String address;
    /** 租户数据隔离 */
    @Comment("租户数据隔离")
    @Column()
    private String tenantIsolation;
    /** 数据库是否已初始化 */
    @Comment("数据库是否已初始化")
    @Column()
    private Boolean dbInitialized;
    /** 租户数据隔离数据源 */
    @Comment("租户数据隔离数据源")
    @Column()
    private Long databaseSourceId;
    /** schema名称，如果租户数据隔离通过schema */
    @Comment("schema名称，如果租户数据隔离通过schema")
    @Column()
    private String schemaName;
    /** 域名地址 */
    @Comment("域名地址")
    @Column()
    private String tenantDomain;
    /** 租户自定义域名 */
    @Comment("租户自定义域名")
    @Column()
    private String customDomain;
    /** 管理员登录账号 */
    @Comment("管理员登录账号")
    @Column()
    private String adminAccount;
    /** 基础数据同步记录ID */
    @Comment("基础数据同步记录ID")
    @Column()
    private Long baseDataSyncId;
    /** 所属行业，[UDC]COM:INDUSTRY */
    @Comment("所属行业，[UDC]COM:INDUSTRY")
    @Column()
    private String industry;
    /** 所属客户，[UDC]SYS:CUSTOMER */
    @Comment("所属客户，[UDC]SYS:CUSTOMER")
    @Column()
    private String customer;
    /** 平台租户主键 */
    @Comment("平台租户主键")
    @Column()
    private Long sysTenantId;

    public void copy(TwTenantDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
