package com.elitesland.tw.tw5crm.server.tenant.service;

import com.elitesland.tw.tw5crm.server.tenant.repo.AuthTenantRepo;
import com.elitesland.tw.tw5crm.server.tenant.dao.AuthTenantDAO;
import com.elitesland.tw.tw5crm.server.tenant.convert.AuthTenantConvert;
import com.elitesland.tw.tw5crm.api.tenant.service.AuthTenantService;
import com.elitesland.tw.tw5crm.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5crm.server.tenant.entity.AuthTenantDO;
import com.elitesland.tw.tw5crm.api.tenant.vo.AuthTenantVO;
import com.elitesland.tw.tw5crm.api.tenant.query.AuthTenantQuery;
import com.elitesland.tw.tw5crm.server.tenant.convert.AuthTenantConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 租户授权
 *
 * @author duwh
 * @date 2023-04-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AuthTenantServiceImpl extends BaseServiceImpl implements AuthTenantService {

    private final AuthTenantRepo authTenantRepo;
    private final AuthTenantDAO authTenantDAO;

    @Override
    public PagingVO<AuthTenantVO> paging(AuthTenantQuery query){
        Page<AuthTenantDO> page = authTenantRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(AuthTenantConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<AuthTenantVO> queryPaging(AuthTenantQuery query){
        return authTenantDAO.queryPaging(query);
    }

    @Override
    public List<AuthTenantVO> queryList(AuthTenantQuery query){
        return AuthTenantConvert.INSTANCE.toVoList(
                authTenantRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
             )
        );
    }

    @Override
    public List<AuthTenantVO> queryListDynamic(AuthTenantQuery query){
        return authTenantDAO.queryListDynamic(query);
    }

    @Override
    public AuthTenantVO queryByKey(Long key) {
        AuthTenantDO entity = authTenantRepo.findById(key).orElseGet(AuthTenantDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AuthTenantVO vo = AuthTenantConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuthTenantVO insert(AuthTenantPayload payload) {
        AuthTenantDO entityDo = AuthTenantConvert.INSTANCE.toDo(payload);
        return AuthTenantConvert.INSTANCE.toVo(authTenantRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuthTenantVO update(AuthTenantPayload payload) {
        AuthTenantDO entity = authTenantRepo.findById(payload.getId()).orElseGet(AuthTenantDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AuthTenantDO entityDo = AuthTenantConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AuthTenantConvert.INSTANCE.toVo(authTenantRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<AuthTenantDO> optional = authTenantRepo.findById(id);
                if (!optional.isEmpty()) {
                    AuthTenantDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    authTenantRepo.save(entity);
                }
             });
        }
    }

}
