package com.elitesland.tw.tw5crm.server.tenant.service;

import cn.hutool.core.util.RandomUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.*;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgDimensionService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemWorkTypeService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.product.payload.*;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessTableColumnsService;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryColumnRefService;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5crm.api.tenant.payload.TwTenantPayload;
import com.elitesland.tw.tw5crm.api.tenant.query.TwTenantQuery;
import com.elitesland.tw.tw5crm.api.tenant.service.AuthTenantService;
import com.elitesland.tw.tw5crm.api.tenant.service.TwTenantService;
import com.elitesland.tw.tw5crm.api.tenant.vo.TwTenantVO;
import com.elitesland.tw.tw5crm.server.common.constants.ProductComponentType;
import com.elitesland.tw.tw5crm.server.tenant.convert.TwTenantConvert;
import com.elitesland.tw.tw5crm.server.tenant.dao.TwTenantDAO;
import com.elitesland.tw.tw5crm.server.tenant.entity.TwTenantDO;
import com.elitesland.tw.tw5crm.server.tenant.repo.TwTenantRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * Tw租户管理
 *
 * @author duwh
 * @date 2023-04-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TwTenantServiceImpl extends BaseServiceImpl implements TwTenantService {

    private final TwTenantRepo twTenantRepo;
    private final TwTenantDAO twTenantDAO;
    private final PrdOrgDimensionService prdOrgDimensionService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdSystemRoleService prdSystemRoleService;
    @Autowired(required = false)
    private PrdOrgEmployeeService prdOrgEmployeeService;
    @Autowired
    private AuthTenantService authTenantService;
    @Autowired
    private CrmOpenseaService crmOpenseaService;
    @Autowired
    private CrmOffshoreService crmOffshoreService;
    @Autowired
    private PrdSystemWorkTypeService prdSystemWorkTypeService;
    @Autowired
    private CrmBusinessTableColumnsService crmBusinessTableColumnsService;
    @Autowired
    private ProductCategoryService productCategoryService;
    @Autowired
    private ProductCategoryColumnRefService productCategoryColumnRefService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String init(Long id) {
        StringBuilder result = new StringBuilder();
        TwTenantVO twTenantVO = queryByKey(id);
        // 初始化标记
        if (twTenantVO.getInited() == null || (twTenantVO.getInited() != null && twTenantVO.getInited().equals(Boolean.FALSE))) {
            final String tenantCode = twTenantVO.getTenantCode();
            final Long sysTenantId = twTenantVO.getSysTenantId();
            final Long adminUserId = twTenantVO.getAdminUserId();
            // 架构有接口支持 同步 发号器数据
            result.append("架构有接口支持 同步 发号器数据；\n");

            // 初始化udc
            AuthTenantPayload authTenantPayload = new AuthTenantPayload();
            // 共用1租户下的udc数据
            authTenantPayload.setAuthTenantId(1L);
            authTenantPayload.setAuthType("UDC");
            authTenantService.insert(authTenantPayload);

            AuthTenantPayload authTenantSelf = new AuthTenantPayload();
            // 能查看自己的udc数据
            authTenantSelf.setAuthTenantId(sysTenantId);
            authTenantSelf.setAuthType("UDC");
            authTenantService.insert(authTenantSelf);

            // tw自己初始化维护以下数据
            // 初始化 维度、组织、角色、人员（PrdOrgPersonDO、PrdOrgEmployeeDO）、角色人员关系（PrdSystemUserRoleDO）

            // 初始化 维度
            PrdOrgDimensionPayload dimensionPayload = new PrdOrgDimensionPayload();
            dimensionPayload.setDimensionName("默认维度");
            dimensionPayload.setDimensionStatus(0);
            dimensionPayload.setDefaultFlag(0);
            dimensionPayload.setInitTenantId(sysTenantId);
            final PrdOrgDimensionVO dimensionVO = prdOrgDimensionService.insertByTenant(dimensionPayload);
            final Long dimensionId = dimensionVO.getId();
            log.info("[租户数据初始化]---维度初始化成功");
            result.append("[租户数据初始化]---维度[默认维度]初始化成功；\n");

            // 资源角色初始化
            final Long resRoleId = resRoleDataProcess(result, sysTenantId);

            // 初始化一套默认组织架构：上海埃林哲软件股份系统有限公司-销售部/市场部
            PrdOrgOrganizationPayload org1 = new PrdOrgOrganizationPayload();
            org1.setInitTenantId(sysTenantId);
            org1.setDimensionId(dimensionId);
            org1.setOrgStatus("ACTIVE");
            org1.setOrgCode("EL");
            org1.setOrgName("上海埃林哲软件股份系统有限公司");
            //org1.setManageId(twUserId);
            final PrdOrgOrganizationVO orgDb1 = prdOrgOrganizationService.insertByTenant(org1);
            result.append("[租户数据初始化]---组织[上海埃林哲软件股份系统有限公司] 初始化成功；\n");
            final Long orgParentId = orgDb1.getId();

            PrdOrgOrganizationPayload org2 = new PrdOrgOrganizationPayload();
            org2.setInitTenantId(sysTenantId);
            org2.setDimensionId(dimensionId);
            org2.setOrgStatus("ACTIVE");
            org2.setOrgCode("SALE_BU");
            org2.setParentId(orgParentId);
            org2.setOrgName("销售部");
            // 负责人
            //org2.setManageId(saleUserId);
            final PrdOrgOrganizationVO saleOrg = prdOrgOrganizationService.insertByTenant(org2);
            result.append("[租户数据初始化]---组织[销售部] 初始化成功；\n");
            final Long saleOrgId = saleOrg.getId();

            PrdOrgOrganizationPayload org3 = new PrdOrgOrganizationPayload();
            org3.setInitTenantId(sysTenantId);
            org3.setDimensionId(dimensionId);
            org3.setOrgStatus("ACTIVE");
            org3.setOrgCode("MARKET_BU");
            org3.setParentId(orgParentId);
            org3.setOrgName("市场部");
            // 负责人
            //org3.setManageId(marketUserId);
            final PrdOrgOrganizationVO marketOrg = prdOrgOrganizationService.insertByTenant(org3);
            result.append("[租户数据初始化]---组织[市场部] 初始化成功；\n");
            final Long marketOrgId = marketOrg.getId();


            // 创建 体验管理员人员
            final PrdOrgEmployeeVO twAdminEmployeee = createEmployee(tenantCode, sysTenantId, adminUserId, resRoleId, "埃林哲CRM", "tw", orgParentId);
            result.append("[租户数据初始化]---人员[埃林哲CRM] 初始化成功；\n");
            final Long twUserId = twAdminEmployeee.getUserId();

            // 创建 销售管理员
            final PrdOrgEmployeeVO saleEmployee = createEmployee(tenantCode, sysTenantId, adminUserId, resRoleId, "销售管理员", "sale", saleOrgId);
            result.append("[租户数据初始化]---人员[销售管理员] 初始化成功；\n");
            final Long saleUserId = saleEmployee.getUserId();
            // 创建 市场管理员
            final PrdOrgEmployeeVO marketEmployee = createEmployee(tenantCode, sysTenantId, adminUserId, resRoleId, "市场管理员", "market", marketOrgId);
            result.append("[租户数据初始化]---人员[市场管理员] 初始化成功；\n");
            final Long marketUserId = marketEmployee.getUserId();

            // 角色数据初始化
            roleDataProcess(result, sysTenantId, twUserId, saleUserId, marketUserId);

            // 初始化默认公海、近海
            saleDataProcess(result, adminUserId, twUserId, saleUserId, marketUserId);

            // 人力成本管理 初始化
            prdSystemWorkTypeService.save("default", "default", "default", new BigDecimal(100));
            result.append("[租户数据初始化]---人力成本管理-初始化成功；\n");

            // 产品模块初始化
            initProduct();
            result.append("[租户数据初始化]---产品模块-初始化成功；\n");

            TwTenantPayload updateTenant = new TwTenantPayload();
            updateTenant.setId(id);
            updateTenant.setInited(true);
            update(updateTenant);
            result.append("[租户数据初始化]---租户初始化标记已更改；\n");

            log.info("[租户数据初始化]---组织初始化成功");

        } else {
            result.append("当前租户数据已初始化，请勿重复操作；\n");
        }
        return result.toString();
    }

    private void initProduct() {
        // 初始化产品属性
        CrmBusinessTableColumnsPayload columnsPayload = new CrmBusinessTableColumnsPayload();
        columnsPayload.setAttributeDesc("版本");
        columnsPayload.setAttributeType("CUSTOM");
        columnsPayload.setComponentType(ProductComponentType.SELECT.getCode());
        columnsPayload.setIsMultiple(1);

        List<CrmSelectChild> selectChildren = new ArrayList<>();
        selectChildren.add(new CrmSelectChild("Sass"));
        selectChildren.add(new CrmSelectChild("OP"));
        columnsPayload.setSelectChildren(selectChildren);
        final CrmBusinessTableColumnsVO columnsVO1 = crmBusinessTableColumnsService.insert(columnsPayload);

        CrmBusinessTableColumnsPayload crmBusinessTableColumnsPayload = new CrmBusinessTableColumnsPayload();
        crmBusinessTableColumnsPayload.setAttributeDesc("部署方式");
        crmBusinessTableColumnsPayload.setAttributeType("CUSTOM");
        crmBusinessTableColumnsPayload.setComponentType(ProductComponentType.SELECT.getCode());
        crmBusinessTableColumnsPayload.setIsMultiple(1);

        List<CrmSelectChild> selectChildren2 = new ArrayList<>();
        selectChildren2.add(new CrmSelectChild("本地"));
        selectChildren2.add(new CrmSelectChild("私有云部署"));
        selectChildren2.add(new CrmSelectChild("公有云部署"));
        selectChildren2.add(new CrmSelectChild("其他"));
        crmBusinessTableColumnsPayload.setSelectChildren(selectChildren2);
        final CrmBusinessTableColumnsVO columnsVO2 = crmBusinessTableColumnsService.insert(crmBusinessTableColumnsPayload);

        // 产品分类初始话
        ProductCategoryPayload category = new ProductCategoryPayload();
        category.setObjName("自研产品");
        category.setParentId(0L);
        category.setPreviewAfter("自研产品");
        final ProductCategoryVO parentCategory = productCategoryService.insert(category);

        ProductCategoryPayload categoryChild1 = new ProductCategoryPayload();
        categoryChild1.setObjName("CRM");
        categoryChild1.setParentId(parentCategory.getId());
        categoryChild1.setPreviewBefore("自研产品");
        categoryChild1.setPreviewAfter("自研产品/CRM");
        final ProductCategoryVO categoryChildVO1 = productCategoryService.insert(categoryChild1);

        ProductCategoryPayload categoryChild2 = new ProductCategoryPayload();
        categoryChild2.setObjName("PMS");
        categoryChild2.setParentId(parentCategory.getId());
        categoryChild2.setPreviewBefore("自研产品");
        categoryChild2.setPreviewAfter("自研产品/PMS");
        final ProductCategoryVO categoryChildVO2 = productCategoryService.insert(categoryChild2);

        // 分类与产品属性的关系
        ProductCategoryColumnRefListPayload columnRefListPayload = new ProductCategoryColumnRefListPayload();
        List<ProductCategoryColumnRefPayload> categoryColumnRefList = new ArrayList<>();
        categoryColumnRefList.add(new ProductCategoryColumnRefPayload(categoryChildVO1.getId(),columnsVO1.getId(),0));
        categoryColumnRefList.add(new ProductCategoryColumnRefPayload(categoryChildVO1.getId(),columnsVO2.getId(),1));
        columnRefListPayload.setCategoryColumnRefList(categoryColumnRefList);
        productCategoryColumnRefService.batchSaveOrUpdate(columnRefListPayload);

        ProductCategoryColumnRefListPayload columnRefListPayload2 = new ProductCategoryColumnRefListPayload();
        List<ProductCategoryColumnRefPayload> categoryColumnRefList2 = new ArrayList<>();
        categoryColumnRefList2.add(new ProductCategoryColumnRefPayload(categoryChildVO2.getId(),columnsVO1.getId(),0));
        categoryColumnRefList2.add(new ProductCategoryColumnRefPayload(categoryChildVO2.getId(),columnsVO2.getId(),1));
        columnRefListPayload2.setCategoryColumnRefList(categoryColumnRefList2);
        productCategoryColumnRefService.batchSaveOrUpdate(columnRefListPayload2);
    }

    /**
     * 资源角色初始化
     *
     * @param result      结果
     * @param sysTenantId sys承租者id
     * @return {@link Long}
     */
    private Long resRoleDataProcess(StringBuilder result, Long sysTenantId) {
        // 初始化 资源 角色 api/system/role/insert
        PrdSystemRolePayload systemRolePayload = new PrdSystemRolePayload();
        systemRolePayload.setEnabled(true);
        systemRolePayload.setRoleCode(RoleEnum.RES.getCode());
        systemRolePayload.setRoleName(RoleEnum.RES.getDesc());
        systemRolePayload.setInitTenantId(sysTenantId);
        // 菜单
        List<Long> menuIds = new ArrayList<>();
        // 系统管理
        menuIds.add(538375007760295350L);
        // 个人工作台
        menuIds.add(570580121954557525L);
        // 个人首页
        menuIds.add(570587279806962715L);
        // 个人中心
        menuIds.add(570590190066734699L);
        // 个人信息
        menuIds.add(570590490278237393L);
        // 我的日程
        menuIds.add(570591605073911112L);
        // 个人流程
        menuIds.add(570596780291399362L);
        // 我的流程
        menuIds.add(570597203068850460L);
        // 工作指派
        menuIds.add(570606837682936734L);
        // 指派列表
        menuIds.add(570625185300879392L);
        // 指派日历
        menuIds.add(570625751284453767L);
        // 指派看板
        menuIds.add(570626106084823714L);

        systemRolePayload.setMenuIds(menuIds);
        final PrdSystemRoleVO resRole = prdSystemRoleService.insert(systemRolePayload);
        final Long resRoleId = resRole.getId();
        result.append("[租户数据初始化]---角色[资源] 初始化成功；\n");
        return resRoleId;
    }

    /**
     * 角色数据初始化
     *
     * @param result       结果
     * @param sysTenantId  sys承租者id
     * @param twUserId     tw用户id
     * @param saleUserId   出售用户id
     * @param marketUserId 市场用户id
     */
    private void roleDataProcess(StringBuilder result, Long sysTenantId, Long twUserId, Long saleUserId, Long marketUserId) {
        // 角色 销售管理员
        PrdSystemRolePayload systemRolePayload1 = new PrdSystemRolePayload();
        systemRolePayload1.setInitTenantId(sysTenantId);
        systemRolePayload1.setEnabled(true);
        systemRolePayload1.setRoleCode(RoleEnum.SALE_ADMIN.getCode());
        systemRolePayload1.setRoleName(RoleEnum.SALE_ADMIN.getDesc());
        // 菜单
        List<Long> menuIds1 = new ArrayList<>();
        menuIds1.add(570587279806962715L);
        menuIds1.add(570606837682936734L);
        menuIds1.add(570590490278237393L);
        menuIds1.add(570591605073911112L);
        menuIds1.add(570597203068850460L);
        menuIds1.add(570625185300879392L);
        menuIds1.add(570625751284453767L);
        menuIds1.add(570626106084823714L);
        menuIds1.add(560143216482191070L);
        menuIds1.add(560158077735931581L);
        menuIds1.add(561221864521734383L);
        menuIds1.add(560143413899691642L);
        menuIds1.add(560173117461496159L);
        menuIds1.add(560174788874866147L);
        menuIds1.add(561568109685639391L);
        menuIds1.add(560176418974344768L);
        menuIds1.add(560176628366583395L);
        menuIds1.add(567094690344601787L);
        menuIds1.add(567095003847854247L);
        menuIds1.add(571071350551092515L);
        menuIds1.add(571068496310443429L);
        menuIds1.add(571072942880855084L);
        menuIds1.add(571073581052597751L);
        menuIds1.add(620970681256903639L);
        menuIds1.add(631521397838979802L);
        menuIds1.add(631521222659679197L);
        menuIds1.add(570630390650247424L);
        menuIds1.add(539797874326646697L);
        menuIds1.add(541288471239590760L);
        menuIds1.add(539854167968063998L);
        menuIds1.add(570632288711218069L);
        menuIds1.add(541284599385304326L);
        menuIds1.add(570590190066734699L);
        menuIds1.add(570596780291399362L);
        menuIds1.add(571070156998971462L);
        menuIds1.add(620968568690838291L);
        menuIds1.add(570580121954557525L);
        menuIds1.add(557583664633218899L);
        menuIds1.add(538375007760295350L);
        menuIds1.add(38441842790891600L);
        menuIds1.add(38441842790891601L);
        menuIds1.add(39112184106582016L);
        menuIds1.add(38372139766644753L);
        menuIds1.add(38441842790891570L);
        menuIds1.add(38372139766644754L);
        menuIds1.add(34009900397887488L);
        menuIds1.add(34009900397887491L);
        menuIds1.add(34009900397887490L);
        menuIds1.add(34009900397887489L);
        menuIds1.add(39112184106582017L);
        systemRolePayload1.setMenuIds(menuIds1);

        List<Long> userIds1 = new ArrayList<>();
        userIds1.add(twUserId);
        userIds1.add(saleUserId);
        systemRolePayload1.setUserIds(userIds1);
        prdSystemRoleService.insert(systemRolePayload1);
        result.append("[租户数据初始化]---角色[销售管理员] 初始化成功；\n");

        // 角色 市场管理员
        PrdSystemRolePayload systemRolePayload2 = new PrdSystemRolePayload();
        systemRolePayload2.setInitTenantId(sysTenantId);
        systemRolePayload2.setEnabled(true);
        systemRolePayload2.setRoleCode(RoleEnum.MARKET_ADMIN.getCode());
        systemRolePayload2.setRoleName(RoleEnum.MARKET_ADMIN.getDesc());
        // 菜单
        List<Long> menuIds2 = new ArrayList<>();
        menuIds2.add(570587279806962715L);
        menuIds2.add(570606837682936734L);
        menuIds2.add(570590490278237393L);
        menuIds2.add(570591605073911112L);
        menuIds2.add(570597203068850460L);
        menuIds2.add(570625185300879392L);
        menuIds2.add(570625751284453767L);
        menuIds2.add(570626106084823714L);
        menuIds2.add(560143216482191070L);
        menuIds2.add(560158077735931581L);
        menuIds2.add(561221864521734383L);
        menuIds2.add(560143413899691642L);
        menuIds2.add(560173117461496159L);
        menuIds2.add(560174788874866147L);
        menuIds2.add(561568109685639391L);
        menuIds2.add(560176418974344768L);
        menuIds2.add(560176628366583395L);
        menuIds2.add(567094690344601787L);
        menuIds2.add(567095003847854247L);
        menuIds2.add(571071350551092515L);
        menuIds2.add(571068496310443429L);
        menuIds2.add(571072942880855084L);
        menuIds2.add(571073581052597751L);
        menuIds2.add(620970681256903639L);
        menuIds2.add(631521397838979802L);
        menuIds2.add(631521222659679197L);
        menuIds2.add(570630390650247424L);
        menuIds2.add(539797874326646697L);
        menuIds2.add(541288471239590760L);
        menuIds2.add(539854167968063998L);
        menuIds2.add(570632288711218069L);
        menuIds2.add(541284599385304326L);
        menuIds2.add(570590190066734699L);
        menuIds2.add(570596780291399362L);
        menuIds2.add(571070156998971462L);
        menuIds2.add(620968568690838291L);
        menuIds2.add(570580121954557525L);
        menuIds2.add(557583664633218899L);
        menuIds2.add(538375007760295350L);
        menuIds2.add(38441842790891600L);
        menuIds2.add(38441842790891601L);
        menuIds2.add(39112184106582016L);
        menuIds2.add(38372139766644753L);
        menuIds2.add(38441842790891570L);
        menuIds2.add(38372139766644754L);
        menuIds2.add(34009900397887488L);
        menuIds2.add(34009900397887491L);
        menuIds2.add(34009900397887490L);
        menuIds2.add(34009900397887489L);
        menuIds2.add(39112184106582017L);
        systemRolePayload2.setMenuIds(menuIds2);
        List<Long> userIds2 = new ArrayList<>();
        userIds2.add(twUserId);
        userIds2.add(marketUserId);
        systemRolePayload2.setUserIds(userIds2);
        prdSystemRoleService.insert(systemRolePayload2);
        result.append("[租户数据初始化]---角色[市场管理员] 初始化成功；\n");
    }

    /**
     * 公海、近海数据初始化
     *
     * @param result       结果
     * @param adminUserId  管理用户id
     * @param twUserId     tw用户id
     * @param saleUserId   出售用户id
     * @param marketUserId 市场用户id
     */
    private void saleDataProcess(StringBuilder result, Long adminUserId, Long twUserId, Long saleUserId, Long marketUserId) {
        CrmOpenseaPayload openseaPayload = new CrmOpenseaPayload();
        openseaPayload.setOpenseaName("默认公海");
        List<CrmOpenseaAdminPayload> crmOpenseaAdminPayloads = new ArrayList<>();
        // 公海管理员
        crmOpenseaAdminPayloads.add(new CrmOpenseaAdminPayload(adminUserId));
        crmOpenseaAdminPayloads.add(new CrmOpenseaAdminPayload(twUserId));
        openseaPayload.setOpenseaAdmins(crmOpenseaAdminPayloads);

        // 公海成员
        List<CrmOpenseaMembersPayload> openseaMembersPayloadList = new ArrayList<>();
        openseaMembersPayloadList.add(new CrmOpenseaMembersPayload(adminUserId));
        openseaMembersPayloadList.add(new CrmOpenseaMembersPayload(twUserId));
        openseaMembersPayloadList.add(new CrmOpenseaMembersPayload(saleUserId));
        openseaMembersPayloadList.add(new CrmOpenseaMembersPayload(marketUserId));
        openseaPayload.setOpenseaMembers(openseaMembersPayloadList);
        crmOpenseaService.saveOne(openseaPayload);
        result.append("[租户数据初始化]---公海[默认公海] 初始化成功；\n");

        // 默认近海初始化
        CrmOffshorePayload crmOffshorePayload = new CrmOffshorePayload();
        crmOffshorePayload.setOffshoreName("默认近海");

        // 近海规则表
        CrmOffshoreRulePayload crmOffshoreRulePayload = new CrmOffshoreRulePayload();
        crmOffshoreRulePayload.setReceiveLeadsLimit(10000);
        crmOffshoreRulePayload.setShowFollowBeforeReceive(0);
        crmOffshoreRulePayload.setNewLeadsRemind(0);
        crmOffshoreRulePayload.setReceiveLeadsLimitDays(0);
        crmOffshoreRulePayload.setDistributeLeadsRemindTime(0L);
        crmOffshoreRulePayload.setFollowLeadsRemindTime(0L);
        crmOffshoreRulePayload.setReceiveLeadsLimitDays(0);
        crmOffshoreRulePayload.setReceiveLeadsRemind(0);
        crmOffshoreRulePayload.setShowFollowBeforeReceive(0);

        // 收回规则
        CrmOffshoreRuleRegainPayload ruleRegainPayload = new CrmOffshoreRuleRegainPayload();
        ruleRegainPayload.setToThisOffshore(1);
        ruleRegainPayload.setRegainRemindTime(0L);
        crmOffshoreRulePayload.setRegainRule(ruleRegainPayload);
        crmOffshorePayload.setOffshoreRule(crmOffshoreRulePayload);

        // 近海管理员
        List<CrmOffshoreAdminPayload> offshoreAdmins = new ArrayList<>();
        offshoreAdmins.add(new CrmOffshoreAdminPayload(twUserId));
        offshoreAdmins.add(new CrmOffshoreAdminPayload(adminUserId));
        crmOffshorePayload.setOffshoreAdmins(offshoreAdmins);

        // 近海成员列表
        List<CrmOffshoreMembersPayload> offshoreMembers = new ArrayList<>();
        offshoreMembers.add(new CrmOffshoreMembersPayload(twUserId));
        offshoreMembers.add(new CrmOffshoreMembersPayload(adminUserId));
        offshoreMembers.add(new CrmOffshoreMembersPayload(saleUserId));
        offshoreMembers.add(new CrmOffshoreMembersPayload(marketUserId));
        crmOffshorePayload.setOffshoreMembers(offshoreMembers);

        crmOffshoreService.saveOne(crmOffshorePayload);
        result.append("[租户数据初始化]---近海[默认近海] 初始化成功；\n");
    }

    /**
     * 创建员工
     *
     * @param tenantCode  租户代码
     * @param sysTenantId sys承租者id
     * @param sysUserId   系统用户id
     * @param resRoleId   res角色id
     * @param orgId       组织主键
     * @return {@link PrdOrgEmployeeVO}
     */
    @Transactional(rollbackFor = Exception.class)
    public PrdOrgEmployeeVO createEmployee(String tenantCode, Long sysTenantId, Long sysUserId, Long resRoleId, String personName, String loginNo, Long orgId) {
        final String s = RandomUtil.randomNumbers(5);
        //final String personName = "埃林哲CRM";
        PrdOrgEmployeePayload employee = new PrdOrgEmployeePayload();
        employee.setInitTenantId(sysTenantId);
        employee.setBirthday(LocalDate.now());
        employee.setEmail(s + "@elitesland.com");
        employee.setEnabled(true);
        employee.setHrStatus("ACTIVE");
        employee.setIdNo("110110200001011010");
        employee.setIdType("ID_CARD");
        employee.setJobs("chairman");

        // 不可重复
        employee.setMobile(s);
        employee.setParentId(sysUserId);

        employee.setPersonName(personName);
        employee.setResourceStatus("3");

        List<Long> roleIds = new ArrayList<>();
        roleIds.add(resRoleId);
        employee.setRoleIds(roleIds);
        //employee.setOrgId(46706467969957960L);

        employee.setEmployeeNo(loginNo + tenantCode);
        employee.setEmployeeName(personName);
        employee.setSex("man");
        employee.setUserName(loginNo + tenantCode);
        employee.setOrgId(orgId);
        final PrdOrgEmployeeVO orgEmployeeVO = prdOrgEmployeeService.insertByTenant(employee);
        return orgEmployeeVO;
    }

    @Override
    public PagingVO<TwTenantVO> queryPaging(TwTenantQuery query) {
        return twTenantDAO.queryPaging(query);
    }

    @Override
    public List<TwTenantVO> queryListDynamic(TwTenantQuery query) {
        return twTenantDAO.queryListDynamic(query);
    }

    @Override
    public TwTenantVO queryByKey(Long key) {
        TwTenantDO entity = twTenantRepo.findById(key).orElseGet(TwTenantDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TwTenantVO vo = TwTenantConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TwTenantVO insert(TwTenantPayload payload) {
        TwTenantDO entityDo = TwTenantConvert.INSTANCE.toDo(payload);
        entityDo.setTenantId(payload.getSysTenantId());
        return TwTenantConvert.INSTANCE.toVo(twTenantRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TwTenantVO update(TwTenantPayload payload) {
        TwTenantDO entity = twTenantRepo.findById(payload.getId()).orElseGet(TwTenantDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TwTenantDO entityDo = TwTenantConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TwTenantConvert.INSTANCE.toVo(twTenantRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TwTenantDO> optional = twTenantRepo.findById(id);
                if (!optional.isEmpty()) {
                    TwTenantDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    twTenantRepo.save(entity);
                }
            });
        }
    }

}
