package com.elitesland.tw.tw5crm.server.visit.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Api(tags = "销售拜访计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/visitPlan")
@Slf4j
public class VisitPlanController {

    private final VisitPlanService visitPlanService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody VisitPlanPayload payload){
        return TwOutputUtil.ok(visitPlanService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody VisitPlanPayload payload){
        return TwOutputUtil.ok(visitPlanService.update(payload));
    }



    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(visitPlanService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(VisitPlanQuery query) {
        return TwOutputUtil.ok(visitPlanService.queryPaging(query));
    }


    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        visitPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PutMapping("/completeVisitPlan")
    @ApiOperation("完成拜访计划")
    public TwOutputUtil completeVisitPlan(@RequestParam Long visitPlanId){
        return TwOutputUtil.ok(visitPlanService.completeVisitPlan(visitPlanId));
    }

    @GetMapping("/verifyVisitPlanName")
    @ApiOperation("验证拜访计划名称")
    public TwOutputUtil verifyVisitPlanName(@RequestParam String visitPlanName){
        return TwOutputUtil.ok(visitPlanService.verifyVisitPlanName(visitPlanName));
    }

    @GetMapping("/visitPlanCount")
    @ApiOperation("拜访计划情况统计")
    public TwOutputUtil visitPlanCount(){
        return TwOutputUtil.ok(visitPlanService.visitPlanCount());
    }

    @GetMapping("/visitCustomAddress")
    @ApiOperation("拜访计划 根据选择客户获得客户详细地址")
    public TwOutputUtil visitCustomAddress(@RequestParam Long customId){
        return TwOutputUtil.ok(visitPlanService.getVisitCustomAddress(customId));
    }

    @GetMapping("/visitCustomRelationInfo")
    @ApiOperation("拜访计划 获得客户关联信息")
    public TwOutputUtil visitCustomRelationInfo(@RequestParam Long customId,@RequestParam String objType){
        return TwOutputUtil.ok(visitPlanService.visitCustomRelationInfo(customId,objType));
    }

}
