package com.elitesland.tw.tw5crm.server.visit.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitSignRecordPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitSignRecordQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitSignRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 销售拜访任务执行情况签到记录
 *
 * @author duwh
 * @date 2023-03-13
 */
@Api(tags = "销售拜访任务执行情况签到记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/visit/signRecord")
@Slf4j
public class VisitSignRecordController {

    private final VisitSignRecordService visitSignRecordService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody VisitSignRecordPayload payload) {
        return TwOutputUtil.ok(visitSignRecordService.insert(payload));
    }

    /**
     * 主键查询 返回附件详情
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询，返回附件详情")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(visitSignRecordService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(VisitSignRecordQuery query) {
        return TwOutputUtil.ok(visitSignRecordService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(VisitSignRecordQuery query) {
        return TwOutputUtil.ok(visitSignRecordService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    //@DeleteMapping("/deleteSoft")
    //@ApiOperation("删除")
    //public TwOutputUtil deleteSoft(Long[] keys) {
    //    visitSignRecordService.deleteSoft(Arrays.asList(keys));
    //    return TwOutputUtil.ok();
    //}

}
