package com.elitesland.tw.tw5crm.server.visit.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Api(tags = "销售拜访任务管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/visit/task")
@Slf4j
public class VisitTaskController {

    private final VisitTaskService visitTaskService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.update(payload));
    }

    /**
     * 领导评价
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("leaderEval")
    @ApiOperation("领导评价")
    public TwOutputUtil leaderEval(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.leaderEval(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(visitTaskService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(VisitTaskQuery query) {
        query.setPermissionFlag(true);
        return TwOutputUtil.ok(visitTaskService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(VisitTaskQuery query) {
        query.setPermissionFlag(true);
        return TwOutputUtil.ok(visitTaskService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        visitTaskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
