package com.elitesland.tw.tw5crm.server.visit.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 销售拜访任务执行情况签到记录
 *
 * @author duwh
 * @date 2023-03-13
 */
@Entity
@Table(name = "crm_visit_sign_record", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_visit_sign_record", comment = "销售拜访任务执行情况签到记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class VisitSignRecordDO extends BaseModel implements Serializable  {
    /** 拜访计划主键 */
    @Comment("拜访计划主键")
    @Column()
    private Long planId;
    /** 拜访任务主键crm_visit_task.id */
    @Comment("拜访任务主键crm_visit_task.id")
    @Column()
    private Long taskId;
    /** 任务名称（冗余）crm_visit_task.task_name */
    @Comment("任务名称（冗余）crm_visit_task.task_name")
    @Column()
    private String taskName;
    @Comment("类型 ( 签到 IN  签退 OUT )")
    @Column()
    private String type;
    /** 签到坐标（最新） */
    @Comment("签到坐标（最新）")
    @Column()
    private String locations;
    /** 签到地点（最新） */
    @Comment("签到地点（最新）")
    @Column()
    private String address;
    /** 签到时间（最新） */
    @Comment("签到时间（最新）")
    @Column()
    private LocalDateTime signTime;
    /** 签到图片（最新） */
    @Comment("签到图片（最新）")
    @Column()
    private String fileCodes;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(VisitSignRecordDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
