package com.elitesland.tw.tw5crm.server.visit.service;

import com.elitesland.tw.tw5crm.server.visit.repo.VisitPlanDetailRepo;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5crm.server.visit.convert.VisitPlanDetailConvert;
import com.elitesland.tw.tw5crm.api.visit.service.VisitPlanDetailService;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitPlanDetailPayload;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitPlanDetailDO;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanDetailVO;
import com.elitesland.tw.tw5crm.api.visit.query.VisitPlanDetailQuery;
import com.elitesland.tw.tw5crm.server.visit.convert.VisitPlanDetailConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 销售拜访计划成员
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class VisitPlanDetailServiceImpl extends BaseServiceImpl implements VisitPlanDetailService {

    private final VisitPlanDetailRepo visitPlanDetailRepo;
    private final VisitPlanDetailDAO visitPlanDetailDAO;

    @Override
    public PagingVO<VisitPlanDetailVO> paging(VisitPlanDetailQuery query){
        Page<VisitPlanDetailDO> page = visitPlanDetailRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(VisitPlanDetailConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<VisitPlanDetailVO> queryPaging(VisitPlanDetailQuery query){
        return visitPlanDetailDAO.queryPaging(query);
    }

    @Override
    public List<VisitPlanDetailVO> queryList(VisitPlanDetailQuery query){
        return VisitPlanDetailConvert.INSTANCE.toVoList(
                visitPlanDetailRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
             )
        );
    }

    @Override
    public List<VisitPlanDetailVO> queryListDynamic(VisitPlanDetailQuery query){
        return visitPlanDetailDAO.queryListDynamic(query);
    }

    @Override
    public VisitPlanDetailVO queryByKey(Long key) {
        VisitPlanDetailDO entity = visitPlanDetailRepo.findById(key).orElseGet(VisitPlanDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        VisitPlanDetailVO vo = VisitPlanDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public VisitPlanDetailVO insert(VisitPlanDetailPayload payload) {
        VisitPlanDetailDO entityDo = VisitPlanDetailConvert.INSTANCE.toDo(payload);
        return VisitPlanDetailConvert.INSTANCE.toVo(visitPlanDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public VisitPlanDetailVO update(VisitPlanDetailPayload payload) {
        VisitPlanDetailDO entity = visitPlanDetailRepo.findById(payload.getId()).orElseGet(VisitPlanDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        VisitPlanDetailDO entityDo = VisitPlanDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return VisitPlanDetailConvert.INSTANCE.toVo(visitPlanDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<VisitPlanDetailDO> optional = visitPlanDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    VisitPlanDetailDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    visitPlanDetailRepo.save(entity);
                }
             });
        }
    }

}
