package com.elitesland.tw.tw5crm.server.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimatePayload;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateService;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;


/**
 * 商机成本估算流程控制器
 *
 * @author duwh
 * @date 2023/03/24
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "OPPO_ESTIMATE_CHANGE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class OpportunityCostEstimateChangeWorkflowController implements WorkflowCallBack {

    private final OpportunityCostEstimateService opportunityCostEstimateService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final OpportunityCostEstimateDAO opportunityCostEstimateDAO;

    /**
     * 动态指定任务负责人
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    @Transactional()
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("流程状态变化回调参数:{}", payload);

        //根据业务key查询当前业务对象
        ComBusinessChangeVO comBusinessChangeVO = businessChangeDao.queryByKey(Long.valueOf(businessKey));
        if (comBusinessChangeVO != null) {
            // 业务信息
            OpportunityCostEstimatePayload opportunityCostEstimatePayload = new OpportunityCostEstimatePayload();
            opportunityCostEstimatePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
            opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());

            // 变更信息
            ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
            changePayload.setId(comBusinessChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            Boolean isUp = false;
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                    changePayload.setChangeStatus(WorkFlowStatusEnum.INTERRUPT.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    changePayload.setChangeStatus(WorkFlowStatusEnum.INVALID.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    isUp = true;
                    opportunityCostEstimatePayload = JSON.parseObject(comBusinessChangeVO.getChangeContent(), OpportunityCostEstimatePayload.class);
                    opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    opportunityCostEstimatePayload.setApprovedTime(LocalDateTime.now());
                    opportunityCostEstimatePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());


                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    break;
                case APPROVING:
                    break;
            }
            businessChangeDao.updateWorkFlow(changePayload);
            if (isUp) {
                opportunityCostEstimateService.updatePro(opportunityCostEstimatePayload);
            } else {
                opportunityCostEstimateDAO.updateWorkFlow(opportunityCostEstimatePayload);
            }
        }
    }
}
