package com.elitesland.tw.tw5pms.server.common.functionEnum;

import lombok.Getter;

/**
 * 工作流程状态枚举
 *
 * @author duwh
 * @date 2023/03/23
 */
public enum ProjectStatusEnum {

    CREATE("1", "新建"),
    APPROVING("2", "立项中"),
    APPROVING_EJECTED("3", "立项驳回"),
    APPROVED("4", "激活"),
    PENDING("5", "暂挂"),
    TERMINATED("6", "已终止"),
    CLOSING("7", "结项中"),
    CLOSE_EJECTED("8", "结项驳回"),
    CLOSED("9", "已结项"),

    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    ProjectStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ProjectStatusEnum getByCode(String code) {
        for (ProjectStatusEnum value : ProjectStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
