/*******************************************************************************
 * $Header$
 * $Revision$
 * $Date$
 *
 *==============================================================================
 *
 * Copyright (c) 2001-2006 Primeton Technologies, Ltd.
 * All rights reserved.
 *
 * Created on 2010-11-15
 *******************************************************************************/


package com.elitesland.tw.tw5pms.server.common.util.criticalPath;

import java.util.LinkedList;
import java.util.List;

/**
 * TASK基础类
 *
 * @author carl
 */
public class Task {
    private String taskNumber;//任务编号
    private String logic;//任务之间的逻辑关系
    private String relyPlanIds;//前置依赖数据

    private double earlyStartTime;//最早开始时间
    private double earlyFinishTime;//最早结束时间
    private double lateStartTime;//最晚开始时间
    private double lateFinishTime;//最晚结束时间
    private double dut;//执行时间
    private double delayTime;//延迟时间
    private double slack;//机动时间

    private String[] logicArray;//任务之间的逻辑关系
    private double[] earlyStartTimeArray;//最早开始时间
    private double[] earlyFinishTimeArray;//最早结束时间
    private double[] lateStartTimeArray;//最晚开始时间
    private double[] lateFinishTimeArray;//最晚结束时间
    private double[] dutArray;//执行时间
    private double[] delayTimeArray;//延迟时间
    private double[] slackArray;//机动时间

    private boolean isCalEST = false;//是否计算了最早开始时间
    private boolean isCalEFT = false;//是否计算了最早结束时间
    private boolean isCalLST = false;//是否计算了最晚开始时间
    private boolean isCalLFT = false;//是否计算了最晚结束时间
    private boolean isCalSlack = false;//是否计算了机动时间


    private boolean isCriticalPath = false;//是否是关键路径

    private List<Task> previousTasks = new LinkedList<Task>();//前置任务集合
    private List<Task> nextTasks = new LinkedList<Task>();//后置任务集合

    /*
     * 计算最早开始时间
     */
    public void calculateET() {
        if (!this.isCalEST()) {
            double est = 0.0d;//临时存放最早开始时间
            boolean isTmp = false;//标记是否执行了逻辑关系中的代码
            if (this.getPreviousTasks().size() == 0) {//第一个任务是没有前置任务的，所以其最早开始时间是0
                this.earlyStartTime = est;
                this.isCalEST = true;
            } else {

                if ("FS".equals(logic)) {//ES= max{ES(前)+ Dur(前)+ FTS}
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (previousTask.getEarlyFinishTime() > est && previousTask.isCalEFT()) {

                            est = previousTask.getEarlyFinishTime();
                            isTmp = previousTask.isCalEFT();
                        }
                    }
                    est = est + this.getDelayTime();
                } else if ("FF".equals(logic)) {//ES= max{ES(前)+ Dur(前) - Dur +FTF}
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (previousTask.getEarlyFinishTime() > est && previousTask.isCalEFT()) {
                            est = previousTask.getEarlyFinishTime();
                            isTmp = previousTask.isCalEFT();
                        }
                    }
                    est = est + this.getDelayTime() - this.getDut();
                } else if ("SS".equals(logic)) {//ES=max{ ES(前) + STS}
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (previousTask.getEarlyStartTime() > est && previousTask.isCalEST()) {
                            est = previousTask.getEarlyStartTime();
                            isTmp = previousTask.isCalEST();
                        }
                    }
                    est = est + this.getDelayTime();
                } else if ("SF".equals(logic)) {//ES=max{ ES(前) - Dur +STF}
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (previousTask.getEarlyStartTime() > est && previousTask.isCalEST()) {
                            est = previousTask.getEarlyStartTime();
                            isTmp = previousTask.isCalEST();
                        }
                    }
                    est = est - this.getDut() + this.getDelayTime();
                }
                if (isTmp) {
                    this.earlyStartTime = est;
                    this.isCalEST = true;
                }
            }
        }
        if (!this.isCalEFT() && this.isCalEST()) {
            this.earlyFinishTime = this.getEarlyStartTime() + this.getDut();
            this.isCalEFT = true;
        }
    }

    /*
     *计算最晚时间
     */
    public void calculateLT() {
        if (!this.isCalLST()) {
            calculateLT(this.nextTasks, this);
        }
        if (!this.isCalLFT()) {
            calculateLT(this.nextTasks, this);
        }
    }


    /*
     * task的后置任务nextTasks
     */
    public void calculateLT(List<Task> nextTasks, Task task) {
        double tmpSlack = 0.0d;//临时时间差   
        boolean isTmp = false;//标记   
        if (nextTasks.size() == 0) {//没有后置任务
            if (task.isCalEST() && task.isCalEFT()) {
                task.lateFinishTime = task.getEarlyFinishTime();
                task.slack = 0.0d;
                task.isCalLFT = true;
                task.isCalSlack = true;
                task.lateStartTime = task.getEarlyStartTime();
                task.slack = 0.0d;
                task.isCalLST = true;
                task.isCalSlack = true;
            }
        } else {
            for (int i = 0; i < nextTasks.size(); i++) {
                Task nextTask = nextTasks.get(i);
                if (!nextTask.isCalLFT())
                    return;
                if (!nextTask.isCalLST())
                    return;
                if (nextTask.isCalSlack) {
                    double _tmp = tmpSlack;//临时时间间隔   
                    if ("FS".equals(nextTask.logic) && nextTask.isCalEST() && task.isCalEFT()) {//Slack = min{slack后+ES后-EF-FTS}
                        _tmp = nextTask.getSlack() + nextTask.getEarlyStartTime() - task.getEarlyFinishTime() - nextTask.getDelayTime();
                        isTmp = true;
                    } else if ("FF".equals(nextTask.logic) && nextTask.isCalEFT() && task.isCalEFT()) {//Slack = min{slack后+EF后-EF-FTF}
                        _tmp = nextTask.getSlack() + nextTask.getEarlyFinishTime() - task.getEarlyFinishTime() - nextTask.getDelayTime();
                        isTmp = true;
                    } else if ("SF".equals(nextTask.logic) && nextTask.isCalEFT() && task.isCalEST()) {//Slack = min｛slack后+EF后-ES-STF｝
                        _tmp = nextTask.getSlack() + nextTask.getEarlyFinishTime() - task.getEarlyStartTime() - nextTask.getDelayTime();
                        isTmp = true;
                    } else if ("SS".equals(nextTask.logic) && nextTask.isCalEST() && task.isCalEST()) {//Slack = min{slack后+ES后-ES-STS}
                        _tmp = nextTask.getSlack() + nextTask.getEarlyStartTime() - task.getEarlyStartTime() - nextTask.getDelayTime();
                        isTmp = true;
                    }
                    if (i == 0) {
                        tmpSlack = _tmp;
                    }
                    if (_tmp < tmpSlack) {
                        tmpSlack = _tmp;
                    }
                }
            }

        }
        if (isTmp && task.isCalEST() && task.isCalEFT()) {//isTmp标记为true，说明已经经过计算。
            task.lateFinishTime = task.getEarlyFinishTime() + tmpSlack;
            task.setSlack(tmpSlack);
            task.isCalLFT = true;
            task.isCalSlack = true;
            task.lateStartTime = task.getEarlyStartTime() + tmpSlack;
            task.setSlack(tmpSlack);
            task.isCalLST = true;
            task.isCalSlack = true;

        }
    }


    /*
     * taskNumber 任务编号
     * logic 与前置任务的逻辑关系
     *  FS，前置任务完成，本任务才开始
     *  SS:前置任务开始，本任务也开始
     *  FF:前置 任务完成，本任务也完成
     *  SF:不考虑，逻辑不同
     * dut 任务执行时间
     *delayTime 提前滞后时间
     */
    public Task(String taskNumber, String logic, double dut, double delayTime) {
        super();
        this.taskNumber = taskNumber;
        this.logic = logic;
        this.dut = dut;
        this.delayTime = delayTime;
    }

    /*
     * taskNumber 任务编号
     * logic 与前置任务的逻辑关系
     *  FS，前置任务完成，本任务才开始
     *  SS:前置任务开始，本任务也开始
     *  FF:前置 任务完成，本任务也完成
     *  SF:不考虑，逻辑不同
     * dut 任务执行时间
     *delayTime 提前滞后时间
     */
    public Task(String taskNumber, String logic, double dut, double delayTime, String relyPlanIds) {
        super();
        this.taskNumber = taskNumber;
        this.logic = logic;
        this.dut = dut;
        this.delayTime = delayTime;
        this.relyPlanIds = relyPlanIds;
    }

    /*
     * taskNumber 任务编号
     * logic 与前置任务的逻辑关系
     * dut 任务执行时间数组
     * delayTime 提前滞后时间数组
     */
    public Task(String taskNumber, String[] logicArray, double[] dutArray, double[] delayTimeArray) {
        super();
        this.taskNumber = taskNumber;
        this.logicArray = logicArray;
        this.dutArray = dutArray;
        this.delayTimeArray = delayTimeArray;
    }

    public String getTaskNumber() {
        return taskNumber;
    }


    public double getDelayTime() {
        return delayTime;
    }


    public double getDut() {
        return dut;
    }

    public String getRelyPlanIds() {
        return relyPlanIds;
    }

    public double getEarlyFinishTime() {
        return earlyFinishTime;
    }

    public double getEarlyStartTime() {
        return earlyStartTime;
    }

    public double getLateFinishTime() {
        return lateFinishTime;
    }

    public double getLateStartTime() {
        return lateStartTime;
    }

    public double getSlack() {
        return slack;
    }

    public void setSlack(double slack) {
        this.slack = slack;
    }

    public boolean isCalEST() {
        ;
        return isCalEST;
    }

    public boolean isCalEFT() {
        ;
        return isCalEFT;
    }

    public boolean isCalLST() {
        return isCalLST;
    }

    public boolean isCalLFT() {
        return isCalLFT;
    }

    public boolean isCriticalPath() {
        return isCriticalPath;
    }

    public List<Task> getPreviousTasks() {
        return previousTasks;
    }


    public void setPreviousTasks(List<Task> previousTasks) {
        this.previousTasks = previousTasks;
        for (Task task : this.previousTasks) {
            task.getNextTasks().add(this);
        }
    }


    public List<Task> getNextTasks() {
        return nextTasks;
    }

    public void setCriticalPath() {
        if (this.isCalLST() && this.isCalEST()) {
            if (this.getLateStartTime() - this.getEarlyStartTime() == 0)
                this.isCriticalPath = true;
        }
    }


}
