/*******************************************************************************
 * $Header$
 * $Revision$
 * $Date$
 *
 *==============================================================================
 *
 * Copyright (c) 2001-2006 Primeton Technologies, Ltd.
 * All rights reserved.
 *
 * Created on 2010-11-15
 *******************************************************************************/


package com.elitesland.tw.tw5pms.server.common.util.criticalPath;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Task的计算逻辑类
 *
 * @author ryan
 */
public class Wbs {
    private List<Task> tasks;//所有任务集合
    private Set<Task> noPreviousTasks;//没有前置任务的任务集合
    private Set<Task> noNextTasks;//没有后置任务的任务集合

    /*
     * tasks 所有任务集合
     */
    public Wbs(List<Task> tasks) {
        super();
        this.tasks = tasks;
        this.noNextTasks = new LinkedHashSet<Task>();
        this.noPreviousTasks = new LinkedHashSet<Task>();
    }

    public List<Task> getTasks() {
        return tasks;
    }

    public static void main(String args[]) {
        Task t1 = new Task("1", "FS", 1, 0);
        Task t2 = new Task("2", "FS", 2, 0);
        Task t3 = new Task("3", "FS", 3, 0);
        Task t4 = new Task("6", "FS", 1.5, 0);
        //创建任务集合
        List<Task> tl = new LinkedList<Task>();
        tl.add(t1);
        tl.add(t2);
        tl.add(t3);
        tl.add(t4);
        //创建每个任务的前置任务集合
        List<Task> tl1 = new LinkedList<Task>();
        List<Task> tl2 = new LinkedList<Task>();
        tl1.add(t1);
        tl2.add(t2);

        t2.setPreviousTasks(tl1);
        t3.setPreviousTasks(tl1);
        t4.setPreviousTasks(tl2);
//        t7.setPreviousTasks(tl3);


        Wbs wbs = new Wbs(tl);
        //计算关键路线
        wbs.calculateTime();
        //打印计算结果
        for (Task task0 : wbs.tasks) {
            task0.setCriticalPath();
            System.out.println(task0.getTaskNumber() + "tnumber==" + task0.getEarlyStartTime() + "est===" + task0.getEarlyFinishTime() + "eft===" + task0.getLateStartTime() + "lst===" + task0.getLateFinishTime() + "lft====" + task0.isCriticalPath());
        }
    }

    public void operKeyPath() {
        /**
         * 前置依赖筛选
         * 1.选择时间最长路径
         * 2.选择延迟最小的路径
         */
        calculateTime();
        List<Task> taskList = this.tasks.stream().filter(task -> task.isCriticalPath()).collect(Collectors.toList());
        Optional<Task> max = taskList.stream().max(Comparator.comparingDouble(Task::getLateFinishTime));


    }

    /*
     * 计算最早最晚时间
     */
    public void calculateTime() {
        //计算没有前置任务的任务
        Set<Task> firstTimes = calculateNoPreviousEarlyTime(this.tasks);
        //依次分层计算后一层的任务EST，EFT
        Set<Task> nextTimes = calculateEarlyTime(firstTimes);
        Set<Task> tmpTasks;
        do {
            tmpTasks = nextTimes;
            nextTimes = calculateEarlyTime(tmpTasks);

        } while (nextTimes.size() > 0);

        firstTimes.clear();
        nextTimes.clear();
        tmpTasks.clear();
        //计算没有后置任务的任务
        firstTimes = calNoNextTasksLateTime(this.tasks);
        //依次分层计算后一层的任务的LST
        nextTimes = calculateLateTime(firstTimes);
        do {
            tmpTasks = nextTimes;
            nextTimes = calculateLateTime(tmpTasks);

        } while (nextTimes.size() > 0);


    }

    /**
     * @param tasks 所有任务
     * @return 没有前置任务计算完成之后，待计算的任务
     */
    private Set<Task> calculateNoPreviousEarlyTime(List<Task> tasks) {
        Set<Task> calTasks = new LinkedHashSet<Task>();
        if (tasks != null && tasks.size() > 0) {
            Set<Task> noPreviousTasks = this.getNoPreviousTasks(tasks);
            for (Task task : noPreviousTasks) {
                if (!task.isCalEST() && !task.isCalEFT()) {
                    task.calculateET();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    /**
     * @param tasks 所有任务集合
     * @return 没有前置任务的任务集合
     */
    public Set<Task> getNoPreviousTasks(List<Task> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                if (task != null && task.getPreviousTasks().size() == 0) {
                    this.noPreviousTasks.add(task);
                }
            }
        }
        return this.noPreviousTasks;
    }


    /**
     * @param nextTasks 本次待计算的任务
     * @return 下一次待计算的任务（前置任务处理完的其后置任务以及前置任务没处理完的本任务）
     */
    public Set<Task> calculateEarlyTime(Set<Task> nextTasks) {
        Set<Task> calTasks = new LinkedHashSet<Task>();
        if (nextTasks != null && nextTasks.size() > 0) {
            Iterator<Task> it = nextTasks.iterator();
            while (it.hasNext()) {
                Task task = it.next();
                //      System.out.println("本次需要计算的任务是"+task.getTaskNumber());
                //找到本任务的前置任务看是不是全部计算完成了，
                List<Task> befTask = task.getPreviousTasks();
                //判断本任务的前置任务是不是完全计算完成的计数器
                int count = 0;//计数器
                for (int i = 0; i < befTask.size(); i++) {
                    Task bfTask = befTask.get(i);
                    if (bfTask.isCalEST() && bfTask.isCalEFT())
                        count++;
                }
                //如果全部计算完成，将本任务的后置任务加入到返回列表里
                if (count == befTask.size()) {
                    task.calculateET();
                    //          System.out.println("已经计算了"+task.getTaskNumber());
                    calTasks.addAll(task.getNextTasks());
                    //如果没有全部计算完成，把本任务加入到计算列表里
                } else {
                    calTasks.add(task);
                }
            }
        }
        return calTasks;
    }

    /**
     * @param tasks 所有任务
     * @return 没有前置任务的下一层需要计算的任务
     */
    public Set<Task> calNoNextTasksLateTime(List<Task> tasks) {
        Set<Task> calTasks = new LinkedHashSet<Task>();
        if (tasks != null && tasks.size() > 0) {
            for (Task task : this.getNoNextTasks(tasks)) {
                if (!task.isCalLST() && !task.isCalLFT())
                    task.calculateLT();
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    /**
     * @param tasks 所有任务集合
     * @return 没有后置任务的任务集合
     */
    public Set<Task> getNoNextTasks(List<Task> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                if (task != null && task.getNextTasks().size() == 0) {
                    this.noNextTasks.add(task);
                }
            }
        }
        return this.noNextTasks;
    }

    /**
     * @param nextTasks 本次待计算的任务
     * @return 下一次需要计算的任务
     */
    public Set<Task> calculateLateTime(Set<Task> nextTasks) {
        Set<Task> calTasks = new LinkedHashSet<Task>();
        if (nextTasks != null && nextTasks.size() > 0) {
            Iterator<Task> it = nextTasks.iterator();
            while (it.hasNext()) {
                Task task = it.next();
                //找到本任务的后置任务看是不是全部计算完成了，
                List<Task> nextTask = task.getNextTasks();
                //判断本任务的后置任务是不是完全计算完成的计数器
                int count = 0;//计数器
                for (int i = 0; i < nextTask.size(); i++) {
                    Task ntTask = nextTask.get(i);
                    if (ntTask.isCalLST() && ntTask.isCalLFT())
                        count++;
                }
                //如果全部计算完成，将本任务的后置任务加入到返回列表里
                if (count == nextTask.size()) {
                    task.calculateLT();
                    //          System.out.println("计算的是"+task.getTaskNumber());
                    calTasks.addAll(task.getPreviousTasks());
                    //如果没有全部计算完成，把本任务加入到计算列表里
                } else {
                    calTasks.add(task);
                }
            }
        }
        return calTasks;
    }

}  

