package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目
 *
 * @author carl
 * @date 2023-03-22
 */
@Api(tags = "项目")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/project")
@Slf4j
public class PmsProjectController {

    private final PmsProjectService pmsProjectService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsProjectPayload payload) {
        return TwOutputUtil.ok(pmsProjectService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsProjectPayload payload) {
        return TwOutputUtil.ok(pmsProjectService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectService.queryByKey(key));
    }

    /**
     * 提交立项流程
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/submitStartProject/{key}")
    // @UdcNameClass
    @ApiOperation("提交立项流程")
    public TwOutputUtil submitStartProject(@PathVariable Long key) {
        pmsProjectService.submitStartProject(key);
        return TwOutputUtil.ok();
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsProjectQuery query) {
        return TwOutputUtil.ok(pmsProjectService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectQuery query) {
        return TwOutputUtil.ok(pmsProjectService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 执行流程内数据变更
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/updateWorkflowProject")
    @ApiOperation("执行流程内数据变更")
    public TwOutputUtil updateWorkflowProject(@RequestBody PmsProjectPayload payload) {
        pmsProjectService.updateWorkflowProject(payload);
        return TwOutputUtil.ok();
    }


}
