package com.elitesland.tw.tw5pms.server.project.controller;


import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目计划
 *
 * @author carl
 * @date 2023-04-17
 */
@Api(tags = "项目计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectPlan")
@Slf4j
public class PmsProjectPlanController {

    private final PmsProjectPlanService pmsProjectPlanService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil batchInsertOrUpdate(@RequestBody PmsProjectPlanDataPayload payload) {
        return TwOutputUtil.ok(pmsProjectPlanService.batchInsertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectPlanService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsProjectPlanQuery query) {
        return TwOutputUtil.ok(pmsProjectPlanService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectPlanQuery query) {
        return TwOutputUtil.ok(pmsProjectPlanService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 查询日志列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryLogList")
    @ApiOperation("查询日志列表")
    public TwOutputUtil queryLogList(PmsProjectPlanLogQuery query) {
        return TwOutputUtil.ok(pmsProjectPlanService.queryLogList(query));
    }

    /**
     * 新增快照
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertSnapshot")
    @ApiOperation("新增快照")
    public TwOutputUtil insertSnapshot(@RequestBody PmsProjectPlanSnapshotPayload payload) {
        return TwOutputUtil.ok(pmsProjectPlanService.insertSnapshot(payload));
    }

    /**
     * 查询快照列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/querySnapshotList")
    @ApiOperation("查询快照列表")
    public TwOutputUtil querySnapshotList(PmsProjectPlanSnapshotQuery query) {
        return TwOutputUtil.ok(pmsProjectPlanService.querySnapshotList(query));
    }

    /**
     * 删除快照
     *
     * @param snapshotKeys 快照主键id
     * @return result
     */
    @DeleteMapping("/deleteSoftSnapshot")
    @ApiOperation("删除快照")
    public TwOutputUtil deleteSoftSnapshot(Long[] snapshotKeys) {
        pmsProjectPlanService.deleteSoftSnapshot(Arrays.asList(snapshotKeys));
        return TwOutputUtil.ok();
    }
}
