package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTeamBasePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTeamBaseQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamBaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目成员基本信息
 *
 * @author Echo
 * @date 2023-04-11
 */
@Api(tags = "项目成员基本信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsProjectTeamBase")
@Slf4j
public class PmsProjectTeamBaseController {

    private final PmsProjectTeamBaseService pmsProjectTeamBaseService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsProjectTeamBasePayload payload){
        return TwOutputUtil.ok(pmsProjectTeamBaseService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsProjectTeamBasePayload payload){
        return TwOutputUtil.ok(pmsProjectTeamBaseService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectTeamBaseService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsProjectTeamBaseQuery query) {
        return TwOutputUtil.ok(pmsProjectTeamBaseService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectTeamBaseQuery query) {
        return TwOutputUtil.ok(pmsProjectTeamBaseService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectTeamBaseService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }



    /**
     * 项目id查询
     *
     * @param projectId 项目Id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryByProjectId/{projectId}")
    // @UdcNameClass
    @ApiOperation("根据项目Id查询")
    public TwOutputUtil queryByProjectId(@PathVariable Long projectId) {
        return TwOutputUtil.ok(pmsProjectTeamBaseService.queryByProjectId(projectId));
    }
}
