package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTeamMemberPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTeamMemberQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目成员资质信息
 *
 * @author Echo
 * @date 2023-04-11
 */
@Api(tags = "项目成员资质信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsProjectTeamMember")
@Slf4j
public class PmsProjectTeamMemberController {

    private final PmsProjectTeamMemberService pmsProjectTeamMemberService;

    /**
     * 新增
     *
     * @param payloads 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("批量新增")
    public TwOutputUtil insert(@RequestBody List<PmsProjectTeamMemberPayload> payloads){
        return TwOutputUtil.ok(pmsProjectTeamMemberService.insert(payloads));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsProjectTeamMemberPayload payload){
        return TwOutputUtil.ok(pmsProjectTeamMemberService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectTeamMemberService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsProjectTeamMemberQuery query) {
        return TwOutputUtil.ok(pmsProjectTeamMemberService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectTeamMemberQuery query) {
        return TwOutputUtil.ok(pmsProjectTeamMemberService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectTeamMemberService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
