package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目模板
 *
 * @author carl
 * @date 2023-03-22
 */
@Api(tags = "项目模板")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/projectTemplate")
@Slf4j
public class PmsProjectTemplateController {

    private final PmsProjectTemplateService pmsProjectTemplateService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsProjectTemplatePayload payload) {
        return TwOutputUtil.ok(pmsProjectTemplateService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsProjectTemplatePayload payload) {
        return TwOutputUtil.ok(pmsProjectTemplateService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectTemplateService.queryByKey(key));
    }

    /**
     * 模板分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("模板分页")
    public TwOutputUtil paging(PmsProjectTemplateQuery query) {
        return TwOutputUtil.ok(pmsProjectTemplateService.paging(query));
    }

    /**
     * 预制模板分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/prePaging")
    // @UdcNameClass
    @ApiOperation("预制模板分页")
    public TwOutputUtil prePaging(PmsProjectTemplateQuery query) {
        return TwOutputUtil.ok(pmsProjectTemplateService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectTemplateQuery query) {
        return TwOutputUtil.ok(pmsProjectTemplateService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectTemplateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改状态
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/updateStatus")
    @ApiOperation("修改状态")
    public TwOutputUtil updateStatus(Long[] keys) {
        pmsProjectTemplateService.updateStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();

    }
}
