package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Api(tags = "项目wbs表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsProjectWbs")
@Slf4j
public class PmsProjectWbsController {

    private final PmsProjectWbsService pmsProjectWbsService;

    /**
     * 批量新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("批量新增或修改")
    public TwOutputUtil batchInsertOrUpdate(@RequestBody PmsProjectWbsDataPayload payload) {
        return TwOutputUtil.ok(pmsProjectWbsService.batchInsertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryByKey(key));
    }


    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsProjectWbsQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectWbsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 查询日志列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryLogList")
    @ApiOperation("查询日志列表")
    public TwOutputUtil queryLogList(PmsProjectWbsLogQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryLogList(query));
    }


}
