package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsWbsTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * wbs模板
 *
 * @author Echo
 * @date 2023-03-29
 */
@Api(tags = "wbs模板")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsWbsTemplate")
@Slf4j
public class PmsWbsTemplateController {

    private final PmsWbsTemplateService pmsWbsTemplateService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsWbsTemplatePayload payload){
        return TwOutputUtil.ok(pmsWbsTemplateService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsWbsTemplatePayload payload){
        return TwOutputUtil.ok(pmsWbsTemplateService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsWbsTemplateService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsWbsTemplateQuery query) {
        return TwOutputUtil.ok(pmsWbsTemplateService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsWbsTemplateQuery query) {
        return TwOutputUtil.ok(pmsWbsTemplateService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsWbsTemplateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改状态
     *
     * @param keys 主键集合
     * @return result
     */
    @DeleteMapping("/updateStatus")
    @ApiOperation("修改状态")
    public TwOutputUtil updateStatus(Long[] keys){

        pmsWbsTemplateService.updateStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
