package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目
 *
 * @author carl
 * @date 2023-03-22
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectRepo repo;
    private final QPmsProjectDO qdo = QPmsProjectDO.pmsProjectDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 项目名称
                qdo.projectName,
                // 项目编号
                qdo.projectCode,
                // 客户id
                qdo.custId,
                qdo.custName,
                // 客户行业
                qdo.custIndustry,
                // 客户区域
                qdo.custArea,
                // 交付地点
                qdo.paySite,
                // 项目类型
                qdo.projectType,
                // 项目模板id
                qdo.templateId,
                qdo.templateName,
                // 项目难度
                qdo.projectDifficulty,
                // 项目重要度
                qdo.projectImportance,
                // 是否签订合同
                qdo.haveContract,
                // 合同附件
                qdo.contractFiles,
                // 开始时间
                qdo.startTime,
                // 结束时间
                qdo.endTime,
                // sow节选
                qdo.sowFiles,
                // 项目状态
                qdo.projectStatus,
                // 项目经理
                qdo.managerUserId,
                // pmo负责人
                qdo.pmoManagerUserId,
                // 交付负责人
                qdo.payManagerUserId,
                // 销售负责人
                qdo.saleManagerUserId,
                // 预算总人天
                qdo.totalDays,
                // 费用总预算
                qdo.totalMoney,
                // 费用总成本
                qdo.totalCost,
                // 预算附件
                qdo.budgetFiles,
                // 客户承担差旅
                qdo.custBear,
                // 补贴限额
                qdo.subsidyLimit,
                // 允许转包
                qdo.permitSubcontract,
                // 工时结算周期
                qdo.timesheetPeriod,
                // 最低保证金
                qdo.depositMin,
                // 拓展字段
                qdo.extString1,
                // 拓展字段
                qdo.extString2,
                // 拓展字段
                qdo.extString3,
                // 拓展字段
                qdo.extString4,
                // 拓展字段
                qdo.extString5,
                // 拓展字段
                qdo.extString6,
                // 拓展字段
                qdo.extString7,
                // 拓展字段
                qdo.extString8,
                // 拓展字段
                qdo.extString9,
                // 拓展字段
                qdo.extString10,
                // 隐藏字段
                qdo.hideFields
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQueryWhere(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

//    /**
//     * 统计
//     *
//     * @param query 查询参数
//     * @return jpaQuery对象
//     */
//    public long count(ProjectQuery query) {
//        long total = jpaQueryFactory
//            .select(qdo.count())
//            .from(qdo)
//            .where(where(query))
//            .fetchOne();
//        return total;
//    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 项目名称或编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjectNameOrCode())) {
            String s = SqlUtil.toSqlLikeString(query.getProjectNameOrCode());
            list.add(qdo.projectName.like(s).or(qdo.projectCode.like(s)));
        }
        /** 项目名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjectName())) {
            list.add(qdo.projectName.like(SqlUtil.toSqlLikeString(query.getProjectName())));
        }
        /** 项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjectCode())) {
            list.add(qdo.projectCode.like(SqlUtil.toSqlLikeString(query.getProjectCode())));
        }
        /** 客户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdo.custId.eq(query.getCustId()));
        }
        /** 客户行业 精确 */
        if (!ObjectUtils.isEmpty(query.getCustIndustry())) {
            list.add(qdo.custIndustry.eq(query.getCustIndustry()));
        }
        /** 客户区域 精确 */
        if (!ObjectUtils.isEmpty(query.getCustArea())) {
            list.add(qdo.custArea.eq(query.getCustArea()));
        }
        /** 交付地点 精确 */
        if (!ObjectUtils.isEmpty(query.getPaySite())) {
            list.add(qdo.paySite.eq(query.getPaySite()));
        }
        /** 项目类型 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectType())) {
            list.add(qdo.projectType.eq(query.getProjectType()));
        }
        /** 项目模板id 精确 */
        if (!ObjectUtils.isEmpty(query.getTemplateId())) {
            list.add(qdo.templateId.eq(query.getTemplateId()));
        }
        /** 项目难度 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectDifficulty())) {
            list.add(qdo.projectDifficulty.eq(query.getProjectDifficulty()));
        }
        /** 项目重要度 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectImportance())) {
            list.add(qdo.projectImportance.eq(query.getProjectImportance()));
        }
        /** 是否签订合同 精确 */
        if (!ObjectUtils.isEmpty(query.getHaveContract())) {
            list.add(qdo.haveContract.eq(query.getHaveContract()));
        }
        /** 合同附件 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFiles())) {
            list.add(qdo.contractFiles.eq(query.getContractFiles()));
        }
        BooleanExpression jpaQueryOr0 = null;

        if (!ObjectUtils.isEmpty(query.getStartTime()) && !ObjectUtils.isEmpty(query.getEndTime())) {
            jpaQueryOr0 = qdo.startTime.loe(query.getStartTime()).and(qdo.endTime.goe(query.getStartTime()));
            //list.add(qdo.startTime.goe(query.getStartTime()));
        }
        if (!ObjectUtils.isEmpty(query.getEndTime())) {
            if (jpaQueryOr0 != null) {
                jpaQueryOr0 = jpaQueryOr0.or(qdo.startTime.loe(query.getEndTime()).and(qdo.endTime.goe(query.getEndTime())));
            } else {
                jpaQueryOr0 = qdo.startTime.loe(query.getEndTime()).and(qdo.endTime.goe(query.getEndTime()));
            }
            //list.add(qdo.endTime.loe(query.getEndTime()));
        }
        if (jpaQueryOr0 != null) {
            list.add(jpaQueryOr0);
        }
        /** sow节选 精确 */
        if (!ObjectUtils.isEmpty(query.getSowFiles())) {
            list.add(qdo.sowFiles.eq(query.getSowFiles()));
        }
        /** 项目状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
            if (!ObjectUtils.isEmpty(query.getProjectStatusType()) && "1".equals(query.getProjectStatusType())) {
                list.add(qdo.projectStatus.ne(query.getProjectStatus()));
            } else {
                list.add(qdo.projectStatus.eq(query.getProjectStatus()));
            }
        }
        /** 项目经理 精确 */
        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
            list.add(qdo.managerUserId.eq(query.getManagerUserId()));
        }
        /** pmo负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoManagerUserId())) {
            list.add(qdo.pmoManagerUserId.eq(query.getPmoManagerUserId()));
        }
        /** 交付负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getPayManagerUserId())) {
            list.add(qdo.payManagerUserId.eq(query.getPayManagerUserId()));
        }
        /** 销售负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleManagerUserId())) {
            list.add(qdo.saleManagerUserId.eq(query.getSaleManagerUserId()));
        }
        /** 预算总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 费用总预算 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalMoney())) {
            list.add(qdo.totalMoney.eq(query.getTotalMoney()));
        }
        /** 费用总成本 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalCost())) {
            list.add(qdo.totalCost.eq(query.getTotalCost()));
        }
        /** 预算附件 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetFiles())) {
            list.add(qdo.budgetFiles.eq(query.getBudgetFiles()));
        }
        /** 客户承担差旅 精确 */
        if (!ObjectUtils.isEmpty(query.getCustBear())) {
            list.add(qdo.custBear.eq(query.getCustBear()));
        }
        /** 补贴限额 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidyLimit())) {
            list.add(qdo.subsidyLimit.eq(query.getSubsidyLimit()));
        }
        /** 允许转包 精确 */
        if (!ObjectUtils.isEmpty(query.getPermitSubcontract())) {
            list.add(qdo.permitSubcontract.eq(query.getPermitSubcontract()));
        }
        /** 工时结算周期 精确 */
        if (!ObjectUtils.isEmpty(query.getTimesheetPeriod())) {
            list.add(qdo.timesheetPeriod.eq(query.getTimesheetPeriod()));
        }
        /** 最低保证金 精确 */
        if (!ObjectUtils.isEmpty(query.getDepositMin())) {
            list.add(qdo.depositMin.eq(query.getDepositMin()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            list.add(qdo.extString1.eq(query.getExtString1()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            list.add(qdo.extString2.eq(query.getExtString2()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            list.add(qdo.extString3.eq(query.getExtString3()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            list.add(qdo.extString4.eq(query.getExtString4()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            list.add(qdo.extString5.eq(query.getExtString5()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            list.add(qdo.extString6.eq(query.getExtString6()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString7())) {
            list.add(qdo.extString7.eq(query.getExtString7()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString8())) {
            list.add(qdo.extString8.eq(query.getExtString8()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString9())) {
            list.add(qdo.extString9.eq(query.getExtString9()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString10())) {
            list.add(qdo.extString10.eq(query.getExtString10()));
        }
        /** 隐藏字段 精确 */
        if (!ObjectUtils.isEmpty(query.getHideFields())) {
            list.add(qdo.hideFields.eq(query.getHideFields()));
        }
        //需要权限
        if (query.getPermissionFlag()) {
            BooleanExpression jpaQueryOr = qdo.createUserId.eq(query.getLoginUserId()).or(qdo.managerUserId.eq(query.getLoginUserId())).or(qdo.pmoManagerUserId.eq(query.getLoginUserId()));
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectVO queryByKey(Long id) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryListDynamic(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query) {
//        long total = count(query);
//        if (total == 0) {
//             return PagingVO.empty();
//        }
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PmsProjectVO> results = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetchResults();
        return PagingVO.<PmsProjectVO>builder().records(results.getResults()).total(results.getTotal()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectDO save(PmsProjectDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectDO> saveAll(List<PmsProjectDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 项目名称
        if (payload.getProjectName() != null) {
            update.set(qdo.projectName, payload.getProjectName());
        }
        // 项目编号
        if (payload.getProjectCode() != null) {
            update.set(qdo.projectCode, payload.getProjectCode());
        }
        // 客户id
        if (payload.getCustId() != null) {
            update.set(qdo.custId, payload.getCustId());
        }
        // 客户行业
        if (payload.getCustIndustry() != null) {
            update.set(qdo.custIndustry, payload.getCustIndustry());
        }
        // 客户区域
        if (payload.getCustArea() != null) {
            update.set(qdo.custArea, payload.getCustArea());
        }
        // 交付地点
        if (payload.getPaySite() != null) {
            update.set(qdo.paySite, payload.getPaySite());
        }
        // 项目类型
        if (payload.getProjectType() != null) {
            update.set(qdo.projectType, payload.getProjectType());
        }
        // 项目模板id
        if (payload.getTemplateId() != null) {
            update.set(qdo.templateId, payload.getTemplateId());
        }
        // 项目难度
        if (payload.getProjectDifficulty() != null) {
            update.set(qdo.projectDifficulty, payload.getProjectDifficulty());
        }
        // 项目重要度
        if (payload.getProjectImportance() != null) {
            update.set(qdo.projectImportance, payload.getProjectImportance());
        }
        // 是否签订合同
        if (payload.getHaveContract() != null) {
            update.set(qdo.haveContract, payload.getHaveContract());
        }
        // 合同附件
        if (payload.getContractFiles() != null) {
            update.set(qdo.contractFiles, payload.getContractFiles());
        }
        // 开始时间
        if (payload.getStartTime() != null) {
            update.set(qdo.startTime, payload.getStartTime());
        }
        // 结束时间
        if (payload.getEndTime() != null) {
            update.set(qdo.endTime, payload.getEndTime());
        }
        // sow节选
        if (payload.getSowFiles() != null) {
            update.set(qdo.sowFiles, payload.getSowFiles());
        }
        // 项目状态
        if (payload.getProjectStatus() != null) {
            update.set(qdo.projectStatus, payload.getProjectStatus());
        }
        // 项目经理
        if (payload.getManagerUserId() != null) {
            update.set(qdo.managerUserId, payload.getManagerUserId());
        }
        // pmo负责人
        if (payload.getPmoManagerUserId() != null) {
            update.set(qdo.pmoManagerUserId, payload.getPmoManagerUserId());
        }
        // 交付负责人
        if (payload.getPayManagerUserId() != null) {
            update.set(qdo.payManagerUserId, payload.getPayManagerUserId());
        }
        // 销售负责人
        if (payload.getSaleManagerUserId() != null) {
            update.set(qdo.saleManagerUserId, payload.getSaleManagerUserId());
        }
        // 预算总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 费用总预算
        if (payload.getTotalMoney() != null) {
            update.set(qdo.totalMoney, payload.getTotalMoney());
        }
        // 费用总成本
        if (payload.getTotalCost() != null) {
            update.set(qdo.totalCost, payload.getTotalCost());
        }
        // 预算附件
        if (payload.getBudgetFiles() != null) {
            update.set(qdo.budgetFiles, payload.getBudgetFiles());
        }
        // 客户承担差旅
        if (payload.getCustBear() != null) {
            update.set(qdo.custBear, payload.getCustBear());
        }
        // 补贴限额
        if (payload.getSubsidyLimit() != null) {
            update.set(qdo.subsidyLimit, payload.getSubsidyLimit());
        }
        // 允许转包
        if (payload.getPermitSubcontract() != null) {
            update.set(qdo.permitSubcontract, payload.getPermitSubcontract());
        }
        // 工时结算周期
        if (payload.getTimesheetPeriod() != null) {
            update.set(qdo.timesheetPeriod, payload.getTimesheetPeriod());
        }
        // 最低保证金
        if (payload.getDepositMin() != null) {
            update.set(qdo.depositMin, payload.getDepositMin());
        }
        // 拓展字段
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        // 拓展字段
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        // 拓展字段
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        // 拓展字段
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        // 拓展字段
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 拓展字段
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        // 拓展字段
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        // 拓展字段
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        // 拓展字段
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        // 拓展字段
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }
        // 隐藏字段
        if (payload.getHideFields() != null) {
            update.set(qdo.hideFields, payload.getHideFields());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目名称
            if (nullFields.contains("projectName")) {
                update.setNull(qdo.projectName);
            }
            // 项目编号
            if (nullFields.contains("projectCode")) {
                update.setNull(qdo.projectCode);
            }
            // 客户id
            if (nullFields.contains("custId")) {
                update.setNull(qdo.custId);
            }
            // 客户行业
            if (nullFields.contains("custIndustry")) {
                update.setNull(qdo.custIndustry);
            }
            // 客户区域
            if (nullFields.contains("custArea")) {
                update.setNull(qdo.custArea);
            }
            // 交付地点
            if (nullFields.contains("paySite")) {
                update.setNull(qdo.paySite);
            }
            // 项目类型
            if (nullFields.contains("projectType")) {
                update.setNull(qdo.projectType);
            }
            // 项目模板id
            if (nullFields.contains("templateId")) {
                update.setNull(qdo.templateId);
            }
            // 项目难度
            if (nullFields.contains("projectDifficulty")) {
                update.setNull(qdo.projectDifficulty);
            }
            // 项目重要度
            if (nullFields.contains("projectImportance")) {
                update.setNull(qdo.projectImportance);
            }
            // 是否签订合同
            if (nullFields.contains("haveContract")) {
                update.setNull(qdo.haveContract);
            }
            // 合同附件
            if (nullFields.contains("contractFiles")) {
                update.setNull(qdo.contractFiles);
            }
            // 开始时间
            if (nullFields.contains("startTime")) {
                update.setNull(qdo.startTime);
            }
            // 结束时间
            if (nullFields.contains("endTime")) {
                update.setNull(qdo.endTime);
            }
            // sow节选
            if (nullFields.contains("sowFiles")) {
                update.setNull(qdo.sowFiles);
            }
            // 项目状态
            if (nullFields.contains("projectStatus")) {
                update.setNull(qdo.projectStatus);
            }
            // 项目经理
            if (nullFields.contains("managerUserId")) {
                update.setNull(qdo.managerUserId);
            }
            // pmo负责人
            if (nullFields.contains("pmoManagerUserId")) {
                update.setNull(qdo.pmoManagerUserId);
            }
            // 交付负责人
            if (nullFields.contains("payManagerUserId")) {
                update.setNull(qdo.payManagerUserId);
            }
            // 销售负责人
            if (nullFields.contains("saleManagerUserId")) {
                update.setNull(qdo.saleManagerUserId);
            }
            // 预算总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 费用总预算
            if (nullFields.contains("totalMoney")) {
                update.setNull(qdo.totalMoney);
            }
            // 费用总成本
            if (nullFields.contains("totalCost")) {
                update.setNull(qdo.totalCost);
            }
            // 预算附件
            if (nullFields.contains("budgetFiles")) {
                update.setNull(qdo.budgetFiles);
            }
            // 客户承担差旅
            if (nullFields.contains("custBear")) {
                update.setNull(qdo.custBear);
            }
            // 补贴限额
            if (nullFields.contains("subsidyLimit")) {
                update.setNull(qdo.subsidyLimit);
            }
            // 允许转包
            if (nullFields.contains("permitSubcontract")) {
                update.setNull(qdo.permitSubcontract);
            }
            // 工时结算周期
            if (nullFields.contains("timesheetPeriod")) {
                update.setNull(qdo.timesheetPeriod);
            }
            // 最低保证金
            if (nullFields.contains("depositMin")) {
                update.setNull(qdo.depositMin);
            }
            // 拓展字段
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            // 拓展字段
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
            // 拓展字段
            if (nullFields.contains("extString3")) {
                update.setNull(qdo.extString3);
            }
            // 拓展字段
            if (nullFields.contains("extString4")) {
                update.setNull(qdo.extString4);
            }
            // 拓展字段
            if (nullFields.contains("extString5")) {
                update.setNull(qdo.extString5);
            }
            // 拓展字段
            if (nullFields.contains("extString6")) {
                update.setNull(qdo.extString6);
            }
            // 拓展字段
            if (nullFields.contains("extString7")) {
                update.setNull(qdo.extString7);
            }
            // 拓展字段
            if (nullFields.contains("extString8")) {
                update.setNull(qdo.extString8);
            }
            // 拓展字段
            if (nullFields.contains("extString9")) {
                update.setNull(qdo.extString9);
            }
            // 拓展字段
            if (nullFields.contains("extString10")) {
                update.setNull(qdo.extString10);
            }
            // 隐藏字段
            if (nullFields.contains("hideFields")) {
                update.setNull(qdo.hideFields);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsProjectVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 变更工作流相关数据
     *
     * @param payload
     * @return
     */

    public long updateWorkFlow(PmsProjectPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        // 流程实例id
        if (!ObjectUtils.isEmpty(payload.getProcInstId())) {
            update.set(qdo.procInstId, payload.getProcInstId());
        } else {
            update.setNull(qdo.procInstId);
        }
        // 审批状态
        if (!ObjectUtils.isEmpty(payload.getProcInstStatus())) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        } else {
            update.setNull(qdo.procInstStatus);
        }
        // 状态
        if (!ObjectUtils.isEmpty(payload.getProjectStatus())) {
            update.set(qdo.projectStatus, payload.getProjectStatus());
        }
        // 提审时间
        if (!ObjectUtils.isEmpty(payload.getSubmitTime())) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批结束时间
        if (!ObjectUtils.isEmpty(payload.getApprovedTime())) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (!ObjectUtils.isEmpty(payload.getDeleteFlag())) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }
}

