package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectTemplateDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectTemplateRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目模板
 *
 * @author carl
 * @date 2023-03-22
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectTemplateDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectTemplateRepo repo;
    //    private final QProjectTemplateDO qdo = QProjectTemplateDO.projectTemplateDO;
    private final QPmsProjectTemplateDO qdo = new QPmsProjectTemplateDO("pmsProjectTemplateDO");
    private final QPmsProjectTemplateDO qdo0 = new QPmsProjectTemplateDO("pmsProjectTemplateDO0");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectTemplateVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectTemplateVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 模板类型：预制模板：pre_tem,模板：tem
                qdo.templateType,
                // 模板名称
                qdo.templateName,
                // 适用项目类型
                qdo.suitProjectType,
                // 状态
                qdo.templateStatus,
                qdo.preTemplateId,
                // 拓展字段
                qdo.extString1,
                // 拓展字段
                qdo.extString2,
                // 拓展字段
                qdo.extString3,
                // 拓展字段
                qdo.extString4,
                // 拓展字段
                qdo.extString5,
                // 拓展字段
                qdo.extString6,
                // 拓展字段
                qdo.extString7,
                // 拓展字段
                qdo.extString8,
                // 拓展字段
                qdo.extString9,
                // 拓展字段
                qdo.extString10,
                // 允许隐藏字段
                qdo0.permitHideFields,
                qdo0.templateName.as("preTemplateName"),
                // 隐藏字段
                qdo.hideFields
        )).from(qdo).leftJoin(qdo0).on(qdo.preTemplateId.eq(qdo0.id));
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectTemplateVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectTemplateVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 模板类型：预制模板：pre_tem,模板：tem
                qdo.templateType,
                // 模板名称
                qdo.templateName,
                // 适用项目类型
                qdo.suitProjectType,
                // 状态
                qdo.templateStatus,

                // 拓展字段
                qdo.extString1,
                // 拓展字段
                qdo.extString2,
                // 拓展字段
                qdo.extString3,
                // 拓展字段
                qdo.extString4,
                // 拓展字段
                qdo.extString5,
                // 拓展字段
                qdo.extString6,
                // 拓展字段
                qdo.extString7,
                // 拓展字段
                qdo.extString8,
                // 拓展字段
                qdo.extString9,
                // 拓展字段
                qdo.extString10,
                // 允许隐藏字段
                qdo.permitHideFields,
                // 隐藏字段
                qdo.hideFields
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectTemplateVO> getJpaQueryWhere(PmsProjectTemplateQuery query) {
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

//    /**
//     * 统计
//     *
//     * @param query 查询参数
//     * @return jpaQuery对象
//     */
//    public long count(ProjectTemplateQuery query) {
//        long total = jpaQueryFactory
//                .select(qdo.count())
//                .from(qdo)
//                .where(where(query))
//                .fetchOne();
//        return total;
//    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectTemplateQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 模板类型：预制模板：pre_tem,模板：tem 精确 */
        if (!ObjectUtils.isEmpty(query.getTemplateType())) {
            list.add(qdo.templateType.eq(query.getTemplateType()));
        }
        /** 模板名称 精确 */
        if (!ObjectUtils.isEmpty(query.getTemplateName())) {
            list.add(qdo.templateName.like(SqlUtil.toSqlLikeString(query.getTemplateName())));
        }
        /** 适用项目类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSuitProjectType())) {
            list.add(qdo.suitProjectType.eq(query.getSuitProjectType()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getTemplateStatus())) {
            list.add(qdo.templateStatus.eq(query.getTemplateStatus()));
        }

        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            list.add(qdo.extString1.eq(query.getExtString1()));
        }
        /** 拓展字段 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            list.add(qdo.extString2.eq(query.getExtString2()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsProjectTemplateVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQuerySelect0();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectTemplateVO queryByKey(Long id) {
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param templateName 主键
     * @return 结果
     */
    public PmsProjectTemplateVO queryByName(String templateName) {
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.templateName.eq(templateName));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectTemplateVO> queryListDynamic(PmsProjectTemplateQuery query) {
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 模板分页
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectTemplateVO> paging(PmsProjectTemplateQuery query) {
//        long total = count(query);
//        if (total == 0) {
//            return PagingVO.empty();
//        }
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQueryWhere(query);

        QueryResults<PmsProjectTemplateVO> results = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetchResults();
        return PagingVO.<PmsProjectTemplateVO>builder().records(results.getResults()).total(results.getTotal()).build();
    }

    /**
     * 预制模板分页
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectTemplateVO> queryPaging(PmsProjectTemplateQuery query) {
//        long total = count(query);
//        if (total == 0) {
//            return PagingVO.empty();
//        }
        JPAQuery<PmsProjectTemplateVO> jpaQuery = getJpaQuerySelect0();
        if (StringUtils.hasText(query.getTemplateType())) {
            jpaQuery.where(qdo.templateType.eq(query.getTemplateType()));
        }
        if (StringUtils.hasText(query.getTemplateStatus())) {
            jpaQuery.where(qdo.templateStatus.eq(query.getTemplateStatus()));
        }
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        QueryResults<PmsProjectTemplateVO> results = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetchResults();
        return PagingVO.<PmsProjectTemplateVO>builder().records(results.getResults()).total(results.getTotal()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectTemplateDO save(PmsProjectTemplateDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectTemplateDO> saveAll(List<PmsProjectTemplateDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectTemplatePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 模板类型：预制模板：pre_tem,模板：tem
        if (payload.getTemplateType() != null) {
            update.set(qdo.templateType, payload.getTemplateType());
        }
        // 模板名称
        if (payload.getTemplateName() != null) {
            update.set(qdo.templateName, payload.getTemplateName());
        }
        // 适用项目类型
        if (payload.getSuitProjectType() != null) {
            update.set(qdo.suitProjectType, payload.getSuitProjectType());
        }
        // 状态
        if (payload.getTemplateStatus() != null) {
            update.set(qdo.templateStatus, payload.getTemplateStatus());
        }

        // 拓展字段
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        // 拓展字段
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 模板类型：预制模板：pre_tem,模板：tem
            if (nullFields.contains("templateType")) {
                update.setNull(qdo.templateType);
            }
            // 模板名称
            if (nullFields.contains("templateName")) {
                update.setNull(qdo.templateName);
            }
            // 适用项目类型
            if (nullFields.contains("suitProjectType")) {
                update.setNull(qdo.suitProjectType);
            }
            // 状态
            if (nullFields.contains("templateStatus")) {
                update.setNull(qdo.templateStatus);
            }

            // 拓展字段
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            // 拓展字段
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 修改状态
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.templateStatus, status)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

