package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 项目
 *
 * @author carl
 * @date 2023-03-22
 */
@Entity
@Table(name = "pms_project", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project", comment = "项目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectDO extends BaseModel implements Serializable {
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projectName;
    /**
     * 项目编号
     */
    @Comment("项目编号")
    @Column()
    private String projectCode;
    /**
     * 客户id
     */
    @Comment("客户id")
    @Column()
    private Long custId;
    /**
     * 客户名称
     */
    @Comment("客户名称")
    @Column()
    private String custName;
    /**
     * 客户行业
     */
    @Comment("客户行业")
    @Column()
    private String custIndustry;
    /**
     * 客户区域
     */
    @Comment("客户区域")
    @Column()
    private String custArea;
    /**
     * 交付地点
     */
    @Comment("交付地点")
    @Column()
    private String paySite;
    /**
     * 项目类型
     */
    @Comment("项目类型")
    @Column()
    private String projectType;
    /**
     * 项目模板id
     */
    @Comment("项目模板id")
    @Column()
    private Long templateId;
    /**
     * 项目类型
     */
    @Comment("项目模板名称")
    @Column()
    private String templateName;
    /**
     * 项目难度
     */
    @Comment("项目难度")
    @Column()
    private String projectDifficulty;
    /**
     * 项目重要度
     */
    @Comment("项目重要度")
    @Column()
    private String projectImportance;
    /**
     * 是否签订合同
     */
    @Comment("是否签订合同")
    @Column()
    private Boolean haveContract;
    /**
     * 合同附件
     */
    @Comment("合同附件")
    @Column()
    private String contractFiles;
    /**
     * 开始时间
     */
    @Comment("开始时间")
    @Column()
    private LocalDate startTime;
    /**
     * 结束时间
     */
    @Comment("结束时间")
    @Column()
    private LocalDate endTime;
    /**
     * sow节选
     */
    @Comment("sow节选")
    @Column()
    private String sowFiles;
    /**
     * 项目状态
     */
    @Comment("项目状态")
    @Column()
    private String projectStatus;
    /**
     * 项目经理
     */
    @Comment("项目经理")
    @Column()
    private Long managerUserId;
    /**
     * pmo负责人
     */
    @Comment("pmo负责人")
    @Column()
    private Long pmoManagerUserId;
    /**
     * 交付负责人
     */
    @Comment("交付负责人")
    @Column()
    private Long payManagerUserId;
    /**
     * 销售负责人
     */
    @Comment("销售负责人")
    @Column()
    private Long saleManagerUserId;
    /**
     * 预算总人天
     */
    @Comment("预算总人天")
    @Column()
    private BigDecimal totalDays;
    /**
     * 费用总预算
     */
    @Comment("费用总预算")
    @Column()
    private BigDecimal totalMoney;
    /**
     * 费用总成本
     */
    @Comment("费用总成本")
    @Column()
    private BigDecimal totalCost;
    /**
     * 预算附件
     */
    @Comment("预算附件")
    @Column()
    private String budgetFiles;
    /**
     * 客户承担差旅
     */
    @Comment("客户承担差旅")
    @Column()
    private Boolean custBear;
    /**
     * 补贴限额
     */
    @Comment("补贴限额")
    @Column()
    private BigDecimal subsidyLimit;
    /**
     * 允许转包
     */
    @Comment("允许转包")
    @Column()
    private Boolean permitSubcontract;
    /**
     * 工时结算周期
     */
    @Comment("工时结算周期")
    @Column()
    private String timesheetPeriod;
    /**
     * 最低保证金
     */
    @Comment("最低保证金")
    @Column()
    private BigDecimal depositMin;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString1;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString2;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString3;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString4;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString5;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString6;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString7;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString8;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString9;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString10;
    /**
     * 隐藏字段
     */
    @Comment("隐藏字段")
    @Column()
    private String hideFields;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(PmsProjectDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
