package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目计划
 *
 * @author carl
 * @date 2023-04-17
 */
@Entity
@Table(name = "pms_project_plan", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "parent_index", columnList = "parent_id"),
        @Index(name = "source_index", columnList = "source_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_plan", comment = "项目计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectPlanDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * 父主键
     */
    @Comment("父主键")
    @Column(name = "parent_id")
    private Long parentId;
    /**
     * 计划编码
     */
    @Comment("计划编码")
    @Column()
    private String planCode;
    /**
     * 父计划编码
     */
    @Comment("父计划编码")
    @Column()
    private String parentPlanCode;

    /**
     * 节点编码
     */
    @Comment("节点编码")
    @Column()
    private String nodeCode;
    /**
     * 计划类型（STAGE,ACT,TASK）
     */
    @Comment("计划类型（STAGE,ACT,TASK）")
    @Column()
    private String planType;
    /**
     * 计划描述（名称）
     */
    @Comment("计划描述（名称）")
    @Column()
    private String planName;
    /**
     * 进度(%)
     */
    @Comment("进度(%)")
    @Column()
    private Integer planProgress;
    /**
     * 所属资源id（活动，任务）
     */
    @Comment("所属资源id（活动，任务）")
    @Column(name = "source_id")
    private Long sourceId;
    /**
     * 开始时间
     */
    @Comment("开始时间")
    @Column()
    private LocalDate startDate;
    /**
     * 结束时间
     */
    @Comment("结束时间")
    @Column()
    private LocalDate endDate;
    /**
     * 持续时间（天）
     */
    @Comment("持续时间（天）")
    @Column()
    private BigDecimal durationDay;
    /**
     * 负责人
     */
    @Comment("负责人")
    @Column()
    private Long managerUserId;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String sourceStatus;
    /**
     * 前置依赖计划名称ids
     */
    @Comment("前置依赖计划名称ids")
    @Column()
    private String relyPlanIds;
    /**
     * 前置依赖计划名称
     */
    @Comment("前置依赖计划名称")
    @Column()
    private String relyPlanNames;
    /**
     * 前置依赖资源ids
     */
    @Comment("前置依赖资源ids")
    @Column()
    private String relySourceIds;
    /**
     * 前置类型（FS）
     */
    @Comment("前置类型（FS）")
    @Column()
    private String relyType;
    /**
     * 延迟天数
     */
    @Comment("延迟天数")
    @Column()
    private BigDecimal relyDay;

    /**
     * 是否是关键路径
     */
    @Comment("是否是关键路径")
    @Column()
    private Boolean isKeyPath = false;

    public void copy(PmsProjectPlanDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
