package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 项目计划快照
 *
 * @author carl
 * @date 2023-04-17
 */
@Entity
@Table(name = "pms_project_plan_snapshot", indexes = {
        @Index(name = "project_index", columnList = "project_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_plan_snapshot", comment = "项目计划快照")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectPlanSnapshotDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * 快照（名称）
     */
    @Comment("快照（名称）")
    @Column()
    private String snapName;
    /**
     * 快照内容
     */
    @Comment("快照内容")
    @Column()
    private String snapContent;

    public void copy(PmsProjectPlanSnapshotDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
