package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目成员基本信息
 *
 * @author Echo
 * @date 2023-04-11
 */
@Entity
@Table(name = "pms_project_team_base", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_team_base", comment = "项目成员基本信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectTeamBaseDO extends BaseModel implements Serializable  {
    /** 项目主键 */
    @Comment("项目主键")
    @Column()
    private Long projectId;
    /** 开始周 */
    @Comment("开始周")
    @Column()
    private LocalDate startDate;
    /** 持续周 */
    @Comment("持续周")
    @Column()
    private Integer continueWeek;
    /** 结束周 */
    @Comment("结束周")
    @Column()
    private LocalDate stopDate;

    public void copy(PmsProjectTeamBaseDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
