package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目成员资质信息
 *
 * @author Echo
 * @date 2023-04-11
 */
@Entity
@Table(name = "pms_project_team_member", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_team_member", comment = "项目成员资质信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectTeamMemberDO extends BaseModel implements Serializable {

    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column()
    private Long projectId;
    
    /**
     * 基本信息主键
     */
    @Comment("基本信息主键")
    @Column()
    private Long baseId;
    /**
     * 工种
     */
    @Comment("工种")
    @Column()
    private String workType;
    /**
     * 资源
     */
    @Comment("资源")
    @Column()
    private Long userId;
    /**
     * 专业级别
     */
    @Comment("专业级别")
    @Column()
    private String professionalLevel;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate startDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate stopDate;
    /**
     * 总人天
     */
    @Comment("总人天")
    @Column()
    private BigDecimal totalDays;
    /**
     * week_data
     */
    @Comment("week_data")
    @Column(
            name = "week_data",
            columnDefinition = "text"
    )
    private String weekData;

    public void copy(PmsProjectTeamMemberDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
