package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 项目模板
 *
 * @author carl
 * @date 2023-03-22
 */
@Entity
@Table(name = "pms_project_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_template", comment = "项目模板")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectTemplateDO extends BaseModel implements Serializable {
    /**
     * 预制模板id
     */
    @Comment("预制模板id")
    @Column()
    private Long preTemplateId;

    /**
     * 模板类型：预制模板：pre_tem,模板：tem
     */
    @Comment("模板类型：预制模板：pre_tem,模板：tem")
    @Column()
    private String templateType;
    /**
     * 模板名称
     */
    @Comment("模板名称")
    @Column()
    private String templateName;
    /**
     * 适用项目类型
     */
    @Comment("适用项目类型")
    @Column()
    private String suitProjectType;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String templateStatus;

    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString1;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString2;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString3;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString4;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString5;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString6;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString7;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString8;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString9;
    /**
     * 拓展字段
     */
    @Comment("拓展字段")
    @Column()
    private String extString10;
    /**
     * 允许隐藏字段
     */
    @Comment("允许隐藏字段")
    @Column()
    private String permitHideFields;
    /**
     * 隐藏字段
     */
    @Comment("隐藏字段")
    @Column()
    private String hideFields;

    public void copy(PmsProjectTemplateDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
