package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5pms.api.common.annotation.FieldCreateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Entity
@Table(name = "pms_project_wbs", indexes = {
        @Index(name = "project_index", columnList = "project_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs", comment = "项目wbs表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectWbsDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * 父主键
     */
    @Comment("父主键")
    @Column()
    private Long parentId;
    /**
     * wbs描述（名称）
     */

    @Comment("wbs描述（名称）")
    @Column()
    private String wbsName;
    /**
     * wbs类型(WBS,NET,ACT,MS)
     */
    @FieldCreateLog(fieldName = "节点属性")
    @Comment("wbs类型(WBS,NET,ACT,MS)")
    @Column()
    private String wbsType;
    /**
     * wbs编码
     */
    @Comment("wbs编码")
    @Column()
    private String wbsCode;
    /**
     * 父节点
     */
    @Comment("父节点")
    @Column()
    private String parentWbsCode;

    /**
     * node码
     */
    @FieldCreateLog(fieldName = "节点编码")
    @Comment("node码")
    @Column()
    private String nodeCode;

    /**
     * 成本计划，勾选为1
     */
    @FieldCreateLog(fieldName = "成本计划")
    @Comment("成本计划，勾选为1")
    @Column()
    private Integer costPlan;
    /**
     * 科目分配，勾选为1
     */
    @FieldCreateLog(fieldName = "科目分配")
    @Comment("科目分配，勾选为1")
    @Column()
    private Integer subjectDist;
    /**
     * 开票属性，勾选为1
     */
    @FieldCreateLog(fieldName = "开票属性")
    @Comment("开票属性，勾选为1")
    @Column()
    private Integer invoiceAttr;
    /**
     * 持续时间（天）
     */
    @FieldCreateLog(fieldName = "持续时间（天）")
    @Comment("持续时间（天）")
    @Column()
    private BigDecimal durationDay;
    /**
     * 活动关联任务id
     */
    @Comment("活动关联任务id")
    @Column()
    private Long actTaskId;
    /**
     * 活动成本类型
     */
    @FieldCreateLog(fieldName = "活动成本类型")
    @Comment("活动成本类型")
    @Column()
    private String actCostType;

    public void copy(PmsProjectWbsDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
