package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * wbs模板
 *
 * @author Echo
 * @date 2023-03-29
 */
@Entity
@Table(name = "pms_wbs_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_template", comment = "wbs模板")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsWbsTemplateDO extends BaseModel implements Serializable  {
    /** 模板名称 */
    @Comment("模板名称")
    @Column()
    private String templateName;
    /** 适用项目类型 */
    @Comment("适用项目类型")
    @Column()
    private String suitProjectType;
    /** 模板状态，0：激活，1：暂挂 */
    @Comment("模板状态，0：激活，1：暂挂")
    @Column()
    private String templateStatus;

    public void copy(PmsWbsTemplateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
