package com.elitesland.tw.tw5pms.server.project.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * wbs模板节点
 *
 * @author Echo
 * @date 2023-03-29
 */
@Entity
@Table(name = "pms_wbs_template_node", indexes = {
        @Index(name = "template_index", columnList = "template_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_template_node", comment = "wbs模板节点")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsWbsTemplateNodeDO extends BaseModel implements Serializable  {
    /** 模板主键 */
    @Comment("模板主键")
    @Column(name = "template_id")
    private Long templateId;
    /** 节点描述（名称） */
    @Comment("节点描述（名称）")
    @Column()
    private String wbsName;
    /** 节点类型(WBS,NET,ACT,MS) */
    @Comment("节点类型(WBS,NET,ACT,MS)")
    @Column()
    private String wbsType;
    /** 节点编码 */
    @Comment("节点编码")
    @Column()
    private String nodeCode;
    /** wbs码 */
    @Comment("wbs码")
    @Column()
    private String wbsCode;
    /** 父级wbs码 */
    @Comment("父级wbs码")
    @Column()
    private String parentWbsCode;

    public void copy(PmsWbsTemplateNodeDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
