package com.elitesland.tw.tw5pms.server.project.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanSnapshotService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSimpleVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSnapshotVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.common.util.criticalPath.Task;
import com.elitesland.tw.tw5pms.server.common.util.criticalPath.Wbs;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectPlanConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectPlanDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectPlanDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectPlanRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目计划
 *
 * @author carl
 * @date 2023-04-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectPlanServiceImpl extends BaseServiceImpl implements PmsProjectPlanService {
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO projectDAO;
    private final CacheUtil cacheUtil;
    private final PmsProjectPlanRepo pmsProjectPlanRepo;
    private final PmsProjectPlanDAO pmsProjectPlanDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final TransactionUtilService transactionUtilService;
    private final PmsProjectPlanSnapshotService planSnapshotService;

    @Override
    @Transactional(rollbackFor = Exception.class)

    public PmsProjectPlanVO batchInsertOrUpdate(PmsProjectPlanDataPayload payload) {
        //核验数据
        checkPlanData(payload);
        /**批量处理plan节点*/
        PmsProjectVO projectVO = projectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty(projectVO)) {
            throw TwException.error("", "关联项目不存在，请核验！");
        }
        List<PmsProjectPlanVO> pmsProjectPlanVOS = pmsProjectPlanDAO.queryByProjectId(payload.getProjectId());
        //要保存的日志数据
        List<ComLogPayload> logPayloads = new ArrayList<>();
        //先处理删除任务
        if (!ObjectUtils.isEmpty(payload.getDelPlanIds())) {
            //要被删除的数据
            List<PmsProjectPlanVO> collect = pmsProjectPlanVOS.stream().filter(planVO -> payload.getDelPlanIds().contains(planVO.getId())).collect(Collectors.toList());
            //要被删除的数据子项任务数据
            List<PmsProjectPlanVO> planVOS = pmsProjectPlanVOS.stream().filter(planVO -> payload.getDelPlanIds().contains(planVO.getParentId()) && planVO.getPlanType().equals("TASK")).collect(Collectors.toList());
            //核验删除数据
            checkDelPlan(planVOS, payload.getDelPlanIds());
            //获取删除变更日志
            createPlanDelLog(logPayloads, collect);
            //执行删除
            pmsProjectPlanDAO.deleteSoft(payload.getDelPlanIds());
            pmsProjectPlanVOS.removeAll(collect);
        }
        //处理计划数据
        List<PmsProjectPlanPayload> planPayloads = payload.getPlanPayloads();
        List<PmsProjectPlanDO> updateDOs = new ArrayList<>();
        if (!ObjectUtils.isEmpty(planPayloads)) {
            //核验计划数据
            checkPlan(planPayloads, pmsProjectPlanVOS);
            //获取变更的节点
            List<PmsProjectPlanPayload> updatePayloads = planPayloads.stream().filter(planPayload -> planPayload.getId() != null).collect(Collectors.toList());
            //创建plan节点变更日志
            List<Long> updateIds = createPlanUpdateLog(logPayloads, pmsProjectPlanVOS, updatePayloads);

            List<PmsProjectPlanDO> entityDos = planPayloads.stream().map(e -> {
                e.setProjectId(payload.getProjectId());
                if (e.getId() == null && e.getPlanType().equals("STAGE")) {
                    String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000);
                    Random random = new Random();
                    int s = random.nextInt(99) % (90) + 10;
                    e.setNodeCode(projectVO.getProjectCode() + "-STG-" + (lastFourDigits + s));
                }
                PmsProjectPlanDO planDO = PmsProjectPlanConvert.INSTANCE.toDo(e);
                e.setPlanDO(planDO);
                return planDO;
            }).collect(Collectors.toList());
            List<PmsProjectPlanDO> pmsProjectPlanDOS = pmsProjectPlanDAO.saveAll(entityDos);

            //替换vo中更新的新值
            pmsProjectPlanDOS.forEach(planDO -> {
                Optional<PmsProjectPlanVO> first = pmsProjectPlanVOS.stream().filter(planVO -> planVO.getId().equals(planDO.getId())).findFirst();
                if (first.isPresent()) {
                    pmsProjectPlanVOS.remove(first.get());
                }
                pmsProjectPlanVOS.add(PmsProjectPlanConvert.INSTANCE.toVo(planDO));
            });
            //获取新增的数据
            List<PmsProjectPlanPayload> addPayloads = new ArrayList<>();

            planPayloads.forEach(planPayload1 -> {
                //设置id
                planPayload1.setId(planPayload1.getPlanDO().getId());
                if (!updateIds.contains(planPayload1.getId())) {
                    addPayloads.add(planPayload1);
                }
            });
            //创建新加日志
            createPlanAddLog(logPayloads, addPayloads);
            //更新上级id及前置依赖资源ids
            pmsProjectPlanDOS.forEach(planDO -> {
                boolean isAdd = false;
                if (StringUtils.hasText(planDO.getParentPlanCode())) {
                    Optional<PmsProjectPlanVO> first = pmsProjectPlanVOS.stream().filter(pmsProjectPlanVO -> pmsProjectPlanVO.getPlanCode().equals(planDO.getParentPlanCode())).findFirst();
                    if (first.isPresent()) {
                        planDO.setParentId(first.get().getId());
                        updateDOs.add(planDO);
                        isAdd = true;
                    } else {
                        throw TwException.error("", "上级编号为【" + planDO.getParentPlanCode() + "】不存在，请核验！");
                    }
                }
                if (StringUtils.hasText(planDO.getRelySourceIds())) {
                    List<PmsProjectPlanVO> collect = pmsProjectPlanVOS.stream().filter(pmsProjectPlanVO -> planDO.getRelySourceIds().contains(pmsProjectPlanVO.getSourceId() + "")).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(collect)) {
                        String collect1 = collect.stream().map(PmsProjectPlanVO::getId).map(Objects::toString).collect(Collectors.joining(","));
                        String collect2 = collect.stream().map(PmsProjectPlanVO::getSourceId).map(Objects::toString).collect(Collectors.joining(","));
                        String collect3 = collect.stream().map(PmsProjectPlanVO::getPlanName).collect(Collectors.joining(","));
                        planDO.setRelyPlanIds(collect1);
                        planDO.setRelySourceIds(collect2);
                        planDO.setRelyPlanNames(collect3);
                        if (!isAdd) {
                            updateDOs.add(planDO);
                        }
                    } else {
                        throw TwException.error("", "上级编号为【" + planDO.getParentPlanCode() + "】不存在，请核验！");
                    }
                }
            });
        }
        //处理日志
        if (logPayloads.size() > 0) {
            //版本数据处理
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("项目plan变更");
            changePayload.setChangeDocId(payload.getProjectId() + "");
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_PLAN.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            logService.insertBacth(logPayloads);
        }
        //计算关键路径
        // List<Long> keyIds = operKeyPath(pmsProjectPlanVOS);

//        if (!ObjectUtils.isEmpty(updateDOs) && !ObjectUtils.isEmpty(keyIds)) {
//            updateDOs.forEach(updateDO -> {
//                if (keyIds.contains(updateDO.getId())) {
//                    updateDO.setIsKeyPath(true);
//                    keyIds.remove(updateDO.getId());
//                }
//            });
//        }
        //修改关键路径状态
//        if (!ObjectUtils.isEmpty(keyIds)) {
//            pmsProjectPlanDAO.updateKeyPathByIds(keyIds, true);
//        }
        if (!ObjectUtils.isEmpty(updateDOs)) {
            //开启事务执行修改，主要是修改
            transactionUtilService.executeWithRunnable(() -> {
                pmsProjectPlanDAO.saveAll(updateDOs);
            });
        }

        return null;
    }

    /**
     * 处理关键路径
     *
     * @param pmsProjectPlanVOS
     */
    List<Long> operKeyPath(List<PmsProjectPlanVO> pmsProjectPlanVOS) {
        List<PmsProjectPlanVO> planVOS = new ArrayList<>();
        String relys = ",";
        for (PmsProjectPlanVO pmsProjectPlanVO : pmsProjectPlanVOS) {
            if (pmsProjectPlanVO.getPlanType().equals("ACT")) {
                planVOS.add(pmsProjectPlanVO);
                if (StringUtils.hasText(pmsProjectPlanVO.getRelyPlanIds())) {
                    relys += pmsProjectPlanVO.getRelyPlanIds() + "," + pmsProjectPlanVO.getId() + ",";
                }

            }
        }
        List<Task> tl = new LinkedList<Task>();
        for (PmsProjectPlanVO planVO : pmsProjectPlanVOS) {
            if (relys.contains(planVO.getId() + ",")) {
                //持续天数
                Double durationDay = planVO.getDurationDay() == null ? 0 : planVO.getDurationDay().doubleValue();
                //延迟时间
                Double relyDay = planVO.getRelyDay() == null ? 0 : planVO.getRelyDay().doubleValue();
                //前置依赖类型
                String relyType = StringUtils.hasText(planVO.getRelyType()) ? planVO.getRelyType() : "FS";
                Task task = new Task(planVO.getId() + "", relyType, durationDay, relyDay, planVO.getRelyPlanIds());
                tl.add(task);
            }
        }
        if (!ObjectUtils.isEmpty(tl)) {
            tl.forEach(task -> {
                if (StringUtils.hasText(task.getRelyPlanIds())) {
                    List<Task> collect = tl.stream().filter(task1 -> task.getRelyPlanIds().contains(task1.getTaskNumber())).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(collect)) {
                        task.setPreviousTasks(collect);
                    }
                }
            });
        }

        Wbs wbs = new Wbs(tl);
        //计算关键路线
        wbs.calculateTime();
        List<Long> ids = new ArrayList<>();
        for (Task task : wbs.getTasks()) {
            task.setCriticalPath();
            if (task.isCriticalPath()) {
                ids.add(Long.valueOf(task.getTaskNumber()));
            }

        }
        return ids;
    }

    /**
     * 创建新加日志
     *
     * @param logPayloads
     * @param planPayloads
     */
    void createPlanAddLog(List<ComLogPayload> logPayloads, List<PmsProjectPlanPayload> planPayloads) {
        if (!ObjectUtils.isEmpty(planPayloads)) {
            planPayloads.forEach(planPayload -> {
                String fieldsCreateLog = changeFieldUtil.getFieldsCreateLog(planPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                //  logPayload.setExtString1(vid);
                logPayload.setObjectId(planPayload.getId() + "");
                logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
                logPayload.setExtString2(planPayload.getPlanType());
                logPayload.setExtString3("CREATE");
                logPayload.setExtString4(planPayload.getPlanName());
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    /**
     * 创建plan节点变更日志
     *
     * @param logPayloads
     * @param planPayloads
     */
    List<Long> createPlanUpdateLog
    (List<ComLogPayload> logPayloads, List<PmsProjectPlanVO> planVOS, List<PmsProjectPlanPayload> planPayloads) {
        List<Long> ids = new ArrayList<>();
        if (!ObjectUtils.isEmpty(planPayloads)) {
            planPayloads.forEach(planPayload -> {
                ids.add(planPayload.getId());
                if (!ObjectUtils.isEmpty(planVOS)) {
                    Optional<PmsProjectPlanVO> first = planVOS.stream().filter(planVO -> planVO.getId().equals(planPayload.getId())).findFirst();
                    if (first.isPresent()) {
                        PmsProjectPlanVO pmsProjectPlanVO = first.get();
                        PmsProjectPlanPayload pmsProjectPlanPayload = PmsProjectPlanConvert.INSTANCE.toPayload(pmsProjectPlanVO);
                        transferData(pmsProjectPlanPayload);
                        transferData(planPayload);
                        String fieldsUpdateLog = changeFieldUtil.getFieldsUpdateLog(planPayload, pmsProjectPlanPayload);
                        if (StringUtils.hasText(fieldsUpdateLog)) {

                            ComLogPayload logPayload = new ComLogPayload();
                            logPayload.setObjectId(planPayload.getId() + "");
                            logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());

                            logPayload.setExtString2(planPayload.getPlanType());
                            logPayload.setExtString3("UPDATE");
                            logPayload.setExtString4(planPayload.getPlanName());
                            logPayload.setLogContent(fieldsUpdateLog);
                            logPayloads.add(logPayload);
                        }
                    }
                }
            });
        }
        return ids;
    }

    /**
     * 创建删除plan节点日志
     *
     * @param logPayloads
     * @param collect
     */
    void createPlanDelLog(List<ComLogPayload> logPayloads, List<PmsProjectPlanVO> collect) {
        collect.forEach(planVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId(planVO.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
            logPayload.setLogContent("计划【" + planVO.getPlanName() + "】被删除");
            logPayload.setExtString2(planVO.getPlanType());
            logPayload.setExtString3("DEL");
            logPayload.setExtString4(planVO
                    .getPlanName());
            logPayloads.add(logPayload);
        });

    }

    /**
     * 核验计划数据
     *
     * @param planPayloads
     * @param planVOS
     */
    void checkPlan(List<PmsProjectPlanPayload> planPayloads, List<PmsProjectPlanVO> planVOS) {
        /**
         * 需核验内容
         * 1.开始结束日期核验
         * 2.资源引用不能重复
         * 3.前置依赖关系不能出现循环数据及SF,并且必须有开始和结束时间
         * 4.名称不可重复
         * 5.
         */
        List<String> collect = planPayloads.stream().map(PmsProjectPlanPayload::getPlanName).distinct().collect(Collectors.toList());
        if (planPayloads.size() != collect.size()) {
            throw TwException.error("", "计划描述不可重复，请核验！");
        }
        List<String> collect0 = planPayloads.stream().map(PmsProjectPlanPayload::getPlanCode).distinct().collect(Collectors.toList());
        if (planPayloads.size() != collect0.size()) {
            throw TwException.error("", "计划编码不可重复，请核验！");
        }
        Map<Long, Long> collect1 = planPayloads.stream().filter(planPayload -> planPayload.getSourceId() != null).collect(
                Collectors.groupingBy(PmsProjectPlanPayload::getSourceId, Collectors.counting()));

        Optional<Long> collect2 = collect1.keySet().stream().filter(key -> collect1.get(key) > 1).findFirst();
        if (collect2.isPresent()) {
            throw TwException.error("", "计划关联资源不可重复，请核验！");
        }
//        boolean isHave = ObjectUtils.isEmpty(planVOS) ? false : true;
//        if (isHave) {
//            planVOS.forEach(planVO -> {
//                Optional<PmsProjectPlanPayload> firstPayload = planPayloads.stream().filter(planPayload -> planPayload.getId() != null && planPayload.getId().equals(planVO.getId())).findFirst();
//                if (firstPayload.isPresent()) {
//                    planVO.setPlanCode(firstPayload.get().getPlanCode());
//                    planVO.setPlanName(firstPayload.get().getPlanName());
//                    planVO.setRelySourceIds(firstPayload.get().getRelySourceIds());
//                    planVO.setSourceId(firstPayload.get().getSourceId());
//                }
//            });
//        }

        planPayloads.forEach(planPayload -> {
            if (ObjectUtils.isEmpty(planPayload.getPlanCode())) {
                throw TwException.error("", "计划编码不存在，请核验！");
            }
            if (ObjectUtils.isEmpty(planPayload.getPlanType())) {
                throw TwException.error("", "计划类型不存在，请核验！");
            }
            if (!ObjectUtils.isEmpty(planPayload.getRelyType())) {
                if (!"FS".equals(planPayload.getRelyType()) && !"FF".equals(planPayload.getRelyType()) && !"SS".equals(planPayload.getRelyType())) {
                    throw TwException.error("", "非法前置依赖类型【" + planPayload.getRelyType() + "】，请核验！");
                }

            }
            if (!ObjectUtils.isEmpty(planPayload.getStartDate()) && !ObjectUtils.isEmpty(planPayload.getEndDate())) {
                if (planPayload.getStartDate().isAfter(planPayload.getEndDate())) {
                    throw TwException.error("", "结束时间大于开始时间，请核验！");
                } else {
                    //为持续时间赋值
                    BigDecimal days = new BigDecimal(ChronoUnit.DAYS.between(planPayload.getStartDate(), planPayload.getEndDate()) + 1);
                    planPayload.setDurationDay(days);
                }
            }
            if (!ObjectUtils.isEmpty(planPayload.getRelySourceIds())) {
                if (!"ACT".equals(planPayload.getPlanType())) {
                    throw TwException.error("", "仅支持活动设置前置依赖，请核验！");
                }
                if (ObjectUtils.isEmpty(planPayload.getStartDate()) || ObjectUtils.isEmpty(planPayload.getEndDate())) {
                    throw TwException.error("", "设置前置依赖需保证开始时间和结束时间不为空，请核验！");
                }
                List<PmsProjectPlanPayload> collect3 = planPayloads.stream().filter(plan -> planPayload.getRelySourceIds().contains(plan.getSourceId() + "")).collect(Collectors.toList());
                //延迟时间
                long relyDay = -10000;
                if ("FS".equals(planPayload.getRelyType())) {
                    //取延迟最小的值，所以要初始大值
                    relyDay = 10000;
                }
                for (int i = 0; i < collect3.size(); i++) {
                    PmsProjectPlanPayload planPayload0 = collect3.get(i);
                    if (!"ACT".equals(planPayload0.getPlanType())) {
                        throw TwException.error("", "设置前置依赖必须是活动类型，请核验！");
                    }
                    if (ObjectUtils.isEmpty(planPayload0.getStartDate()) || ObjectUtils.isEmpty(planPayload0.getEndDate())) {
                        throw TwException.error("", "设置前置依赖活动必须设置开始及结束时间，请核验！");
                    }
                    //计算延迟时间

                    if ("FS".equals(planPayload.getRelyType())) {
                        long relyDay0 = ChronoUnit.DAYS.between(planPayload0.getEndDate(), planPayload.getStartDate()) - 1;
                        if (relyDay0 < 0) {
                            throw TwException.error("", "【" + planPayload.getPlanName() + "】设置依赖活动【" + planPayload0.getPlanName() + "】必须设置开始及结束时间不合理，请核验！");
                        }
                        if (relyDay0 < relyDay) {
                            relyDay = relyDay0;
                        }
                    }
                    if ("FF".equals(planPayload.getRelyType())) {
                        long relyDay0 = ChronoUnit.DAYS.between(planPayload.getEndDate(), planPayload0.getEndDate());
                        if (relyDay0 > relyDay) {
                            relyDay = relyDay0;
                        }
                    }
                    if ("SS".equals(planPayload.getRelyType())) {
                        long relyDay0 = ChronoUnit.DAYS.between(planPayload.getStartDate(), planPayload0.getStartDate());
                        if (relyDay0 > relyDay) {
                            relyDay = relyDay0;
                        }
                    }
                }
                planPayload.setRelyDay(new BigDecimal(relyDay));
            }


//            if (isHave) {
//                //判断编号不可重复
//                Optional<PmsProjectPlanVO> first = planVOS.stream().filter(planVO -> planVO.getPlanCode().equals(planPayload.getPlanCode())).findFirst();
//                if (first.isPresent()) {
//                    if (planPayload.getId() == null || !first.get().getId().equals(planPayload.getId())) {
//                        throw TwException.error("", "【" + planPayload.getPlanName() + "】plan编码已存在，请核验！");
//                    }
//                }
//                //判断名称不可重复
//                Optional<PmsProjectPlanVO> first0 = planVOS.stream().filter(planVO -> planVO.getPlanName().equals(planPayload.getPlanName())).findFirst();
//                if (first0.isPresent()) {
//                    if (planPayload.getId() == null || !first0.get().getId().equals(planPayload.getId())) {
//                        throw TwException.error("", "【" + planPayload.getPlanName() + "】计划描述已存在，请核验！");
//                    }
//                }
//                //判断关联资源不可重复
//                Optional<PmsProjectPlanVO> first1 = planVOS.stream().filter(planVO -> planVO.getSourceId().equals(planPayload.getSourceId())).findFirst();
//                if (first1.isPresent()) {
//                    if (planPayload.getId() == null || !first1.get().getId().equals(planPayload.getId())) {
//                        throw TwException.error("", "【" + planPayload.getPlanName() + "】计划描述已存在，请核验！");
//                    }
//                }
//            }
        });

    }

    /**
     * 核对删除数据
     *
     * @param planVOS
     * @param delPlanIds
     */
    void checkDelPlan(List<PmsProjectPlanVO> planVOS, List<Long> delPlanIds) {
        if (!ObjectUtils.isEmpty(planVOS)) {
            Map<Long, List<PmsProjectPlanVO>> groupedList = planVOS.stream().collect(Collectors.groupingBy(PmsProjectPlanVO::getParentId));
            delPlanIds.forEach(delId -> {
                List<PmsProjectPlanVO> pmsProjectPlanVOS = groupedList.get(delId);
                if (!ObjectUtils.isEmpty(pmsProjectPlanVOS)) {
                    List<Long> collect = pmsProjectPlanVOS.stream().map(PmsProjectPlanVO::getId).collect(Collectors.toList());
                    if (!delPlanIds.containsAll(collect)) {
                        throw TwException.error("", "请先为阶段下的任务更换关联项！");
                    }
                }
            });
        }

    }

    @Override
    public PagingVO<PmsProjectPlanVO> queryPaging(PmsProjectPlanQuery query) {
        PagingVO<PmsProjectPlanVO> pmsProjectPlanVOPagingVO = pmsProjectPlanDAO.queryPaging(query);
        pmsProjectPlanVOPagingVO.getRecords().forEach(this::transferData);
        return pmsProjectPlanVOPagingVO;
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectPlanVO vo) {
        vo.setManagerUserName(cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setSourceStatusName(cacheUtil.transferSystemSelection("PMS:PROJECT:PLAN:STATUS", vo.getSourceStatus()));
    }

    /**
     * 翻译数据
     *
     * @param payload
     */
    void transferData(PmsProjectPlanPayload payload) {
        payload.setManagerUserName(cacheUtil.getUserName(payload.getManagerUserId()));
        payload.setSourceStatusName(cacheUtil.transferSystemSelection("PMS:PROJECT:PLAN:STATUS", payload.getSourceStatus()));
    }

    @Override
    public List<PmsProjectPlanVO> queryListDynamic(PmsProjectPlanQuery query) {
        List<PmsProjectPlanVO> planVOS = pmsProjectPlanDAO.queryListDynamic(query);
        planVOS.forEach(this::transferData);
        return planVOS;
    }

    @Override
    public PmsProjectPlanVO queryByKey(Long key) {
        PmsProjectPlanDO entity = pmsProjectPlanRepo.findById(key).orElseGet(PmsProjectPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectPlanVO vo = PmsProjectPlanConvert.INSTANCE.toVo(entity);
        transferData(vo);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectPlanDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<ComLogVO> queryLogList(PmsProjectPlanLogQuery query) {
        if ((query.getProjectId() != null && query.getVersionNo() != null) || query.getPlanId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId(query.getPlanId() + "");
            }
            if (StringUtils.hasText(query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText(query.getPlanType())) {
                logQuery.setExtString2(query.getPlanType());
            }
//            List<ComLogVO> comLogVOS = logService.queryList(logQuery);
//            comLogVOS.forEach(comLogVO -> {
//                String extString3 = comLogVO.getExtString3();
//                if (StringUtils.hasText(extString3)) {
//                    extString3 = extString3.equals("DEL") ? "删除" : extString3.equals("UPDATE") ? "更新" : "创建";
//                }
//                comLogVO.setExtString3(extString3);
//            });
            return logService.queryList(logQuery);
        } else {
            throw TwException.error("", "查询参数异常，请核验！");
        }
    }

    @Override
    public PmsProjectPlanSnapshotVO insertSnapshot(PmsProjectPlanSnapshotPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "归属项目不存在，请核验！");
        }
        List<PmsProjectPlanSimpleVO> pmsProjectPlanVOS = pmsProjectPlanDAO.querySimpleByProjectId(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectPlanVOS)) {
            throw TwException.error("", "基线数据不存在，请核验！");
        }
        String originalContent = JSONObject.toJSONString(pmsProjectPlanVOS);
        payload.setSnapContent(originalContent);
        PmsProjectPlanSnapshotVO insert = planSnapshotService.insert(payload);

        return insert;
    }

    @Override
    public List<PmsProjectPlanSnapshotVO> querySnapshotList(PmsProjectPlanSnapshotQuery query) {
        List<PmsProjectPlanSnapshotVO> pmsProjectPlanSnapshotVOS = planSnapshotService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsProjectPlanSnapshotVOS)) {
            pmsProjectPlanSnapshotVOS.forEach(snapshotVO -> {
                List<PmsProjectPlanSimpleVO> pmsProjectPlanVOS = JSON.parseObject(snapshotVO.getSnapContent(), List.class);
                snapshotVO.setPmsProjectPlanVOS(pmsProjectPlanVOS);
            });
        }
        return pmsProjectPlanSnapshotVOS;
    }

    @Override
    public void deleteSoftSnapshot(List<Long> snapshotKeys) {
        planSnapshotService.deleteSoft(snapshotKeys);
    }


    /**
     * 核对提交数据
     *
     * @param payload
     */
    void checkPlanData(PmsProjectPlanDataPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "归属项目不存在，请核验！");
        }

    }
}
