package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanSnapshotService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSnapshotVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectPlanSnapshotConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectPlanSnapshotDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectPlanSnapshotDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectPlanSnapshotRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 项目计划快照
 *
 * @author carl
 * @date 2023-04-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectPlanSnapshotServiceImpl extends BaseServiceImpl implements PmsProjectPlanSnapshotService {

    private final PmsProjectPlanSnapshotRepo pmsProjectPlanSnapshotRepo;
    private final PmsProjectPlanSnapshotDAO pmsProjectPlanSnapshotDAO;

    @Override
    public PagingVO<PmsProjectPlanSnapshotVO> queryPaging(PmsProjectPlanSnapshotQuery query) {
        return pmsProjectPlanSnapshotDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectPlanSnapshotVO> queryListDynamic(PmsProjectPlanSnapshotQuery query) {
        return pmsProjectPlanSnapshotDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectPlanSnapshotVO queryByKey(Long key) {
        PmsProjectPlanSnapshotDO entity = pmsProjectPlanSnapshotRepo.findById(key).orElseGet(PmsProjectPlanSnapshotDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectPlanSnapshotVO vo = PmsProjectPlanSnapshotConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectPlanSnapshotVO insert(PmsProjectPlanSnapshotPayload payload) {
        PmsProjectPlanSnapshotDO entityDo = PmsProjectPlanSnapshotConvert.INSTANCE.toDo(payload);
        return PmsProjectPlanSnapshotConvert.INSTANCE.toVo(pmsProjectPlanSnapshotRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectPlanSnapshotVO update(PmsProjectPlanSnapshotPayload payload) {
        PmsProjectPlanSnapshotDO entity = pmsProjectPlanSnapshotRepo.findById(payload.getId()).orElseGet(PmsProjectPlanSnapshotDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectPlanSnapshotDO entityDo = PmsProjectPlanSnapshotConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectPlanSnapshotConvert.INSTANCE.toVo(pmsProjectPlanSnapshotRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectPlanSnapshotDAO.deleteSoft(keys);
        }
    }

}
