package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectWbsConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActCostConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActPayConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActCostDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActPayDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActPayDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectWbsServiceImpl extends BaseServiceImpl implements PmsProjectWbsService {
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final ChangeFieldUtil changeFieldUtil;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload) {
        //核验数据
        checkWbsData(payload);
        /**批量处理wbs节点*/
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectVO)) {
            throw TwException.error("", "关联项目不存在，请核验！");
        }
        List<PmsProjectWbsPayload> wbsPayloads = payload.getWbsPayloads();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryByProjectId(payload.getProjectId());
        if (payload.getIsTempCreate()) {
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                List<Long> collect = pmsProjectWbsVOS.stream().map(PmsProjectWbsVO::getId).collect(Collectors.toList());
                payload.setDelWbsIds(collect);
                // wbsPayloads.forEach(wbsPayload -> wbsPayload.setId(null));
            }
        }
        //要保存的日志数据
        List<ComLogPayload> logPayloads = new ArrayList<>();
        //先处理删除的节点
        if (!ObjectUtils.isEmpty(payload.getDelWbsIds())) {
            List<PmsProjectWbsVO> collect = pmsProjectWbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
            //创建删除日志
            createWbsDelLog(logPayloads, collect);
            //删除wbs
            pmsProjectWbsDAO.deleteSoft(payload.getDelWbsIds());
            //删除wbs活动下成本预算
            pmsWbsActCostDAO.deleteSoftByWbsIds(payload.getDelWbsIds());
            //删除wbs活动下交付物
            pmsWbsActPayDAO.deleteSoftByWbsIds(payload.getDelWbsIds());

            pmsProjectWbsVOS.removeAll(collect);
        }
        if (!ObjectUtils.isEmpty(payload.getWbsPayloads())) {
            //核验节点数据
            checkWbs(wbsPayloads, pmsProjectWbsVOS);

            String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000);
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setProjectId(payload.getProjectId());
                if (wbsPayload.getId() == null) {
                    Random random = new Random();
                    int s = random.nextInt(99) % (90) + 10;
                    wbsPayload.setNodeCode(pmsProjectVO.getProjectCode() + "-" + wbsPayload.getWbsType() + "-" + (lastFourDigits + s));
                }
                if (StringUtils.hasText(wbsPayload.getParentWbsCode())) {
                    Optional<PmsProjectWbsPayload> payload1 = wbsPayloads.stream().filter(load -> load.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                    if (payload1.isPresent()) {
                        wbsPayload.setParentWbsName(payload1.get().getWbsName());
                    } else {
                        Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        if (vo1.isPresent()) {
                            wbsPayload.setParentWbsName(vo1.get().getWbsName());
                        }
                    }
                }
            });
            //获取变更的节点
            List<PmsProjectWbsPayload> updatePayloads = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null).collect(Collectors.toList());

            //获取变更日志
            List<Long> updateIds = createWbsUpdateLog(logPayloads, pmsProjectWbsVOS, updatePayloads);

            //  List<PmsProjectWbsDO> entityDos = PmsProjectWbsConvert.INSTANCE.toDoList(wbsPayloads);
            List<PmsProjectWbsDO> entityDos = wbsPayloads.stream().map(e -> {
                PmsProjectWbsDO wbsDO = PmsProjectWbsConvert.INSTANCE.toDo(e);
                e.setWbsDO(wbsDO);
                return wbsDO;
            }).collect(Collectors.toList());
            List<PmsProjectWbsDO> pmsProjectWbsDOS = pmsProjectWbsDAO.saveAll(entityDos);

            //获取新增的节点
            List<PmsProjectWbsPayload> addPayloads = new ArrayList<>();

            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setId(wbsPayload.getWbsDO().getId());
                if (!updateIds.contains(wbsPayload.getId())) {
                    addPayloads.add(wbsPayload);
                }
            });
            //获取创建日志
            createWbsAddLog(logPayloads, addPayloads);
            //处理wbs活动成本预估和交付物
            List<PmsProjectWbsPayload> act = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals("ACT")).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(act)) {
                //核验名称是否重复
                List<PmsWbsActCostVO> pmsWbsActCostVOS = pmsWbsActCostDAO.queryByProjectId(payload.getProjectId());
                List<PmsWbsActPayVO> pmsWbsActPayVOS = pmsWbsActPayDAO.queryByProjectId(payload.getProjectId());
                //要删除的活动成本预估
                List<Long> delActCostIds = new ArrayList<>();
                //要删除的活动交付物
                List<Long> delActPayIds = new ArrayList<>();
                for (PmsProjectWbsPayload wbsPayload : act) {


                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds())) {
                        delActCostIds.addAll(wbsPayload.getDelActCostIds());
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds())) {
                        delActPayIds.addAll(wbsPayload.getDelActPayIds());
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds()) || !ObjectUtils.isEmpty(wbsPayload.getActCostPayloads())) {
                        //操作成本估计日志
                        operActCostLog(logPayloads, wbsPayload, pmsWbsActCostVOS);
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds()) || !ObjectUtils.isEmpty(wbsPayload.getActPayPayloads())) {
                        //操作交付物日志
                        operActPayLog(logPayloads, wbsPayload, pmsWbsActPayVOS);
                    }
                }
                //删除活动成本预估
                if (delActCostIds.size() > 0) {
                    pmsWbsActCostDAO.deleteSoft(delActCostIds);
                    pmsWbsActCostVOS = pmsWbsActCostVOS.stream().filter(costVO -> !delActCostIds.contains(costVO.getId())).collect(Collectors.toList());
                }
                //删除活动交付物
                if (delActPayIds.size() > 0) {
                    pmsWbsActPayDAO.deleteSoft(delActPayIds);
                    pmsWbsActPayVOS = pmsWbsActPayVOS.stream().filter(payVO -> !delActPayIds.contains(payVO.getId())).collect(Collectors.toList());
                }
                //要保存的活动成本预估
                List<PmsWbsActCostPayload> actCostPayloads = new ArrayList<>();
                //要保存的活动交付物
                List<PmsWbsActPayPayload> actPayPayloads = new ArrayList<>();
                // 核验活动下成本估算和交付物数据
                checkWbsAct(act, pmsProjectWbsDOS, actCostPayloads, actPayPayloads, payload.getProjectId(), pmsWbsActCostVOS, pmsWbsActPayVOS);

                //保存的活动成本预估
                if (actCostPayloads.size() > 0) {
                    List<PmsWbsActCostDO> pmsWbsActCostDOS = PmsWbsActCostConvert.INSTANCE.toDoList(actCostPayloads);
                    pmsWbsActCostDAO.saveAll(pmsWbsActCostDOS);
                }
                //保存的活动交付物
                if (actPayPayloads.size() > 0) {
                    List<PmsWbsActPayDO> pmsWbsActPayDOS = PmsWbsActPayConvert.INSTANCE.toDoList(actPayPayloads);
                    pmsWbsActPayDAO.saveAll(pmsWbsActPayDOS);
                }
            }
        }
        //保存操作日志
        if (logPayloads.size() > 0) {
            //版本数据处理
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("项目wbs变更");
            changePayload.setChangeDocId(payload.getProjectId() + "");
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            logService.insertBacth(logPayloads);
        }

        return null;
    }

    /**
     * 操作成本估计日志
     *
     * @param logPayloads
     * @param wbsPayload
     * @param pmsWbsActCostVOS
     */
    void operActCostLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActCostVO> pmsWbsActCostVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals(wbsPayload.getId() + "")).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsPayload.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("成本估计:");
        builder.append("\n");
        //删除的成本估计
        List<String> dels = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds())) {
            dels = pmsWbsActCostVOS.stream().filter(wbsVO -> wbsPayload.getDelActCostIds().contains(wbsVO.getId())).map(PmsWbsActCostVO::getCostName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("删除");
            for (int i = 0; i < dels.size(); i++) {
                if (i == 0) {
                    builder.append("【" + dels.get(i) + "】");
                } else {
                    builder.append(",【" + dels.get(i) + "】");
                }
            }
        }

        List<PmsWbsActCostPayload> actCostPayloads = wbsPayload.getActCostPayloads();
        //新加的成本估计
        List<PmsWbsActCostPayload> adds = new ArrayList<>();
        //变更的成本估计
        List<PmsWbsActCostPayload> updates = new ArrayList<>();
        if (!ObjectUtils.isEmpty(actCostPayloads)) {
            adds = actCostPayloads.stream().filter(actCost -> actCost.getId() == null).collect(Collectors.toList());
            updates = actCostPayloads.stream().filter(actCost -> actCost.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("成本要素-成本估计 创建为");
            builder.append("\n");
            for (PmsWbsActCostPayload add : adds) {
                builder.append(add.getCostName() + "-" + add.getCostEstimate());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("成本要素-成本估计");
            builder.append("\n");
            for (PmsWbsActCostPayload up : updates) {
                Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(actCost -> actCost.getId().equals(up.getId())).findFirst();
                if (firstCost.isPresent()) {
                    PmsWbsActCostVO pmsWbsActCostVO = firstCost.get();
                    if (!pmsWbsActCostVO.getCostName().equals(up.getCostName()) || !pmsWbsActCostVO.getCostEstimate().equals(up.getCostEstimate())) {
                        String str = pmsWbsActCostVO.getCostName() + "-" + pmsWbsActCostVO.getCostEstimate() + "更新为" + up.getCostName() + "-" + up.getCostEstimate();
                        builder.append(str);
                        builder.append("\n");
                    }
                }
            }
        }
        logPayload.setLogContent(builder.toString());

    }

    /**
     * 交付物操作
     *
     * @param logPayloads
     * @param wbsPayload
     * @param pmsWbsActPayVOS
     */
    void operActPayLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals(wbsPayload.getId() + "")).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsPayload.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("交付物:");
        builder.append("\n");
        //删除的成本估计
        List<String> dels = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds())) {
            dels = pmsWbsActPayVOS.stream().filter(wbsVO -> wbsPayload.getDelActPayIds().contains(wbsVO.getId())).map(PmsWbsActPayVO::getPayName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("删除");
            for (int i = 0; i < dels.size(); i++) {
                if (i == 0) {
                    builder.append("【" + dels.get(i) + "】");
                } else {
                    builder.append(",【" + dels.get(i) + "】");
                }
            }
        }

        List<PmsWbsActPayPayload> actPayPayloads = wbsPayload.getActPayPayloads();
        //新加的成本估计
        List<PmsWbsActPayPayload> adds = new ArrayList<>();
        //变更的成本估计
        List<PmsWbsActPayPayload> updates = new ArrayList<>();
        if (!ObjectUtils.isEmpty(actPayPayloads)) {
            adds = actPayPayloads.stream().filter(actPay -> actPay.getId() == null).collect(Collectors.toList());
            updates = actPayPayloads.stream().filter(actPay -> actPay.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("交付物名称-交付物类型 创建为");
            builder.append("\n");
            for (PmsWbsActPayPayload add : adds) {
                builder.append(add.getPayName() + "-" + add.getPayTypeName());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("交付物名称-交付物类型");
            builder.append("\n");
            for (PmsWbsActPayPayload up : updates) {
                Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(actPay -> actPay.getId().equals(up.getId())).findFirst();
                if (firstPay.isPresent()) {
                    PmsWbsActPayVO pmsWbsActPayVO = firstPay.get();
                    if (!pmsWbsActPayVO.getPayName().equals(up.getPayName()) || !pmsWbsActPayVO.getPayTypeName().equals(up.getPayTypeName())) {
                        String str = pmsWbsActPayVO.getPayName() + "-" + pmsWbsActPayVO.getPayTypeName() + "更新为" + up.getPayName() + "-" + up.getPayTypeName();
                        builder.append(str);
                        builder.append("\n");
                    }
                }
            }
        }
        logPayload.setLogContent(builder.toString());

    }

    /**
     * 创建新加日志
     *
     * @param logPayloads
     * @param wbsPayloads
     */
    void createWbsAddLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsPayload> wbsPayloads) {
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                String fieldsCreateLog = changeFieldUtil.getFieldsCreateLog(wbsPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                //  logPayload.setExtString1(vid);
                logPayload.setObjectId(wbsPayload.getId() + "");
                logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());

                logPayload.setExtString2(wbsPayload.getWbsType());
                logPayload.setExtString3("CREATE");
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    /**
     * 创建wbs节点变更日志
     *
     * @param logPayloads
     * @param wbsPayloads
     */
    List<Long> createWbsUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> wbsVOS, List<PmsProjectWbsPayload> wbsPayloads) {
        List<Long> ids = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                ids.add(wbsPayload.getId());
                if (!ObjectUtils.isEmpty(wbsVOS)) {
                    Optional<PmsProjectWbsVO> first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst();
                    if (first.isPresent()) {
                        PmsProjectWbsVO pmsProjectWbsVO = first.get();
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        transferData(pmsProjectWbsPayload);
                        String fieldsUpdateLog = changeFieldUtil.getFieldsUpdateLog(wbsPayload, pmsProjectWbsPayload);
                        if (StringUtils.hasText(fieldsUpdateLog)) {
                            //    fieldsUpdateLog = "【" + wbsPayload.getWbsName() + "】:/n" + fieldsUpdateLog;
                            ComLogPayload logPayload = new ComLogPayload();
                            // logPayload.setExtString1(vid);
                            logPayload.setObjectId(wbsPayload.getId() + "");
                            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());

                            logPayload.setExtString2(wbsPayload.getWbsType());
                            logPayload.setExtString3("UPDATE");
                            logPayload.setLogContent(fieldsUpdateLog);
                            logPayloads.add(logPayload);
                        }
                    }
                }
            });
        }
        return ids;
    }

    /**
     * 创建删除wbs节点日志
     *
     * @param logPayloads
     * @param collect
     */
    void createWbsDelLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> collect) {
        collect.forEach(wbsVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsVO.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setLogContent("节点【" + wbsVO.getWbsName() + "】被删除");
            logPayload.setExtString2(wbsVO.getWbsType());
            logPayload.setExtString3("DEL");
            logPayloads.add(logPayload);
        });

    }

    @Override
    public List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty(query.getProjectId())) {
            throw TwException.error("", "归属项目不可为空，请核验！");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> transferData(pmsProjectWbsVO));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }


    @Override
    public PmsProjectWbsVO queryByKey(Long key) {
        PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(key);
        if (pmsProjectWbsVO.getWbsType().equals("ACT")) {
            List<PmsWbsActCostVO> pmsWbsActCostVOS = pmsWbsActCostDAO.queryByWbsId(key);
            List<PmsWbsActPayVO> pmsWbsActPayVOS = pmsWbsActPayDAO.queryByWbsId(key);
            pmsProjectWbsVO.setActCostVOs(pmsWbsActCostVOS);
            pmsProjectWbsVO.setActPayVOs(pmsWbsActPayVOS);
        }
        transferData(pmsProjectWbsVO);
        return pmsProjectWbsVO;
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectWbsVO vo) {
        vo.setActCostTypeName(cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", vo.getActCostType()));
        // vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            //删除wbs
            pmsProjectWbsDAO.deleteSoft(keys);
            //删除wbs活动下成本预算
            pmsWbsActCostDAO.deleteSoftByWbsIds(keys);
            //删除wbs活动下交付物
            pmsWbsActPayDAO.deleteSoftByWbsIds(keys);
        }
    }

    @Override
    public List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        if ((query.getProjectId() != null && query.getVersionNo() != null) || query.getWbsId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId(query.getWbsId() + "");
            }
            if (StringUtils.hasText(query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText(query.getWbsType())) {
                logQuery.setExtString2(query.getWbsType());
            }
//            List<ComLogVO> comLogVOS = logService.queryList(logQuery);
//            comLogVOS.forEach(comLogVO -> {
//                String extString3 = comLogVO.getExtString3();
//                if (StringUtils.hasText(extString3)) {
//                    extString3 = extString3.equals("DEL") ? "删除" : extString3.equals("UPDATE") ? "更新" : "创建";
//                }
//                comLogVO.setExtString3(extString3);
//            });
            return logService.queryList(logQuery);
        } else {
            throw TwException.error("", "查询参数异常，请核验！");
        }
    }

    /**
     * 核验活动下成本估算和交付物数据
     *
     * @param wbsPayloads
     * @param pmsProjectWbsDOS
     * @param actCostPayloads
     * @param actPayPayloads
     * @param projectId
     */
    void checkWbsAct(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsDO> pmsProjectWbsDOS, List<PmsWbsActCostPayload> actCostPayloads, List<PmsWbsActPayPayload> actPayPayloads, Long projectId, List<PmsWbsActCostVO> pmsWbsActCostVOS, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        //核验名称是否重复
        boolean haveCost = ObjectUtils.isEmpty(pmsWbsActCostVOS) ? false : true;
        boolean havePay = ObjectUtils.isEmpty(pmsWbsActPayVOS) ? false : true;

        for (PmsProjectWbsPayload wbsPayload : wbsPayloads) {

            List<PmsWbsActCostPayload> costPayloads = wbsPayload.getActCostPayloads();
            List<PmsWbsActPayPayload> payloads = wbsPayload.getActPayPayloads();
            if (!ObjectUtils.isEmpty(costPayloads) || !ObjectUtils.isEmpty(payloads)) {
                Optional<PmsProjectWbsDO> first = pmsProjectWbsDOS.stream().filter(wbsDO -> wbsDO.getWbsCode().equals(wbsPayload.getWbsCode())).findFirst();
                PmsProjectWbsDO pmsProjectWbsDO = first.get();
                if (!ObjectUtils.isEmpty(costPayloads)) {
                    List<String> collect = costPayloads.stream().map(PmsWbsActCostPayload::getCostName).distinct().collect(Collectors.toList());
                    if (costPayloads.size() != collect.size()) {
                        throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】活动描述不可重复，请核验！");
                    }
                    //注释掉是因为记录不了名称的变更
//                    if (haveCost) {
//                        pmsWbsActCostVOS.forEach(costVO -> {
//                            Optional<PmsWbsActCostPayload> firstPayload = costPayloads.stream().filter(costPayload -> costPayload.getId() != null && costPayload.getId().equals(costVO.getId())).findFirst();
//                            if (firstPayload.isPresent()) {
//                                costVO.setCostName(firstPayload.get().getCostName());
//                            }
//                        });
//                    }
                    costPayloads.forEach(costPayload -> {
//                        if (haveCost) {
//                            Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(costVO -> costVO.getWbsId().equals(pmsProjectWbsDO.getId()) && costVO.getCostName().equals(costPayload.getCostName())).findFirst();
//                            if (firstCost.isPresent()) {
//                                if (costPayload.getId() == null || !firstCost.get().getId().equals(costPayload.getId())) {
//                                    throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】活动描述不可重复，请核验！");
//                                }
//                            }
//                        }
                        costPayload.setProjectId(projectId);
                        costPayload.setWbsId(pmsProjectWbsDO.getId());
                        costPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                    });
                    actCostPayloads.addAll(costPayloads);
                }
                if (!ObjectUtils.isEmpty(payloads)) {
                    List<String> collect = payloads.stream().map(PmsWbsActPayPayload::getPayName).distinct().collect(Collectors.toList());
                    if (payloads.size() != collect.size()) {
                        throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】目标交付物名称不可重复，请核验！");
                    }
                    //注释掉是因为记录不了名称的变更
//                    if (havePay) {
//                        pmsWbsActPayVOS.forEach(payVO -> {
//                            Optional<PmsWbsActPayPayload> firstPayload = payloads.stream().filter(payload -> payload.getId() != null && payload.getId().equals(payVO.getId())).findFirst();
//                            if (firstPayload.isPresent()) {
//                                payVO.setPayName(firstPayload.get().getPayName());
//                            }
//                        });
//                    }
                    payloads.forEach(payPayload -> {
//                        if (havePay) {
//                            Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(payVO -> payVO.getWbsId().equals(pmsProjectWbsDO.getId()) && payVO.getPayName().equals(payPayload.getPayName())).findFirst();
//                            if (firstPay.isPresent()) {
//                                if (payPayload.getId() == null || !firstPay.get().getId().equals(payPayload.getId())) {
//                                    throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】目标交付物名称不可重复，请核验！");
//                                }
//                            }
//                        }
                        payPayload.setProjectId(projectId);
                        payPayload.setWbsId(pmsProjectWbsDO.getId());
                        payPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                    });
                    actPayPayloads.addAll(payloads);
                }
            }
        }
    }

    /**
     * 核验节点数据
     *
     * @param wbsPayloads
     * @param pmsProjectWbsVOS
     */
    void checkWbs(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> pmsProjectWbsVOS) {

        List<String> collect = wbsPayloads.stream().map(PmsProjectWbsPayload::getWbsName).distinct().collect(Collectors.toList());
        if (wbsPayloads.size() != collect.size()) {
            throw TwException.error("", "节点描述不可重复，请核验！");
        }
        List<String> collect0 = wbsPayloads.stream().map(PmsProjectWbsPayload::getWbsCode).distinct().collect(Collectors.toList());
        if (wbsPayloads.size() != collect0.size()) {
            throw TwException.error("", "wbs编码不可重复，请核验！");
        }
        boolean isHave = ObjectUtils.isEmpty(pmsProjectWbsVOS) ? false : true;
        //先为老数据赋值
        if (isHave) {
            pmsProjectWbsVOS.forEach(wbsVO -> {
                Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(load -> load.getWbsCode().equals(wbsVO.getParentWbsCode())).findFirst();
                if (vo1.isPresent()) {
                    wbsVO.setParentWbsName(vo1.get().getWbsName());
                }
                //注释掉是因为记录不了名称的变更
//                Optional<PmsProjectWbsPayload> firstPayload = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null && wbsPayload.getId().equals(wbsVO.getId())).findFirst();
//                if (firstPayload.isPresent()) {
//                    wbsVO.setWbsCode(firstPayload.get().getWbsCode());
//                    wbsVO.setWbsName(firstPayload.get().getWbsName());
//                }
            });
        }

        wbsPayloads.forEach(entityDo -> {
            if (ObjectUtils.isEmpty(entityDo.getWbsCode())) {
                throw TwException.error("", "wbs编码不存在，请核验！");
            }
            if (ObjectUtils.isEmpty(entityDo.getWbsType())) {
                throw TwException.error("", "wbs类型不存在，请核验！");
            }
            if (ObjectUtils.isEmpty(entityDo.getParentWbsCode())) {
                if (!entityDo.getWbsType().equals("WBS") && !entityDo.getWbsType().equals("NET")) {
                    throw TwException.error("", "一级节点只可新建“WBS元素”和“网络”，请核验！");
                }
            } else {
                Optional<PmsProjectWbsPayload> first = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                String parentWbsType = "";
                if (first.isPresent()) {
                    parentWbsType = first.get().getWbsType();
                } else {
                    Optional<PmsProjectWbsVO> first0 = pmsProjectWbsVOS.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                    if (first0.isPresent()) {
                        parentWbsType = first0.get().getWbsType();
                    } else {
                        throw TwException.error("", entityDo.getParentWbsCode() + "编码数据不存在，请核验！");
                    }
                }
                if (entityDo.getWbsType().equals("WBS")) {
                    if (!parentWbsType.equals("WBS")) {
                        throw TwException.error("", "WBS元素上级只能是WBS元素，请核验！");
                    }
                }
                if (entityDo.getWbsType().equals("NET")) {
                    if (!parentWbsType.equals("WBS")) {
                        throw TwException.error("", "网络上级只能是WBS元素，请核验！");
                    }
                }
                if (entityDo.getWbsType().equals("ACT")) {
                    if (!parentWbsType.equals("WBS") && !parentWbsType.equals("NET")) {
                        throw TwException.error("", "活动上级只能是WBS元素或网络，请核验！");
                    }
                }
                if (entityDo.getWbsType().equals("MS")) {
                    if (!parentWbsType.equals("WBS") && !parentWbsType.equals("NET")) {
                        throw TwException.error("", "活动上级只能是WBS元素或网络，请核验！");
                    }
                }

            }
            //赋值
            transferData(entityDo);
//            if (isHave) {
//                //判断编号不可重复
//                Optional<PmsProjectWbsVO> first = pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(entityDo.getWbsCode())).findFirst();
//
//                if (first.isPresent()) {
//                    if (entityDo.getId() == null || !first.get().getId().equals(entityDo.getId())) {
//                        throw TwException.error("", "【" + entityDo.getWbsName() + "】wbs编码已存在，请核验！");
//                    }
//                }
//                //判断名称不可重复
//                Optional<PmsProjectWbsVO> first0 = pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getWbsName().equals(entityDo.getWbsName())).findFirst();
//                if (first0.isPresent()) {
//                    if (entityDo.getId() == null || !first0.get().getId().equals(entityDo.getId())) {
//                        throw TwException.error("", "【" + entityDo.getWbsName() + "】节点描述已存在，请核验！");
//                    }
//                }
//            }

        });
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectWbsPayload vo) {
        vo.setActCostTypeName(cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", vo.getActCostType()));
        String wbsTypeName = vo.getWbsType().equals("WBS") ? "WBS元素" : vo.getWbsType().equals("NET") ? "网络" : vo.getWbsType().equals("ACT") ? "活动" : "里程碑";
        vo.setWbsTypeName(wbsTypeName);

        if (vo.getInvoiceAttr() != null) {
            vo.setInvoiceAttrName(vo.getInvoiceAttr() == 0 ? "取消勾选" : "勾选");
        }
        if (vo.getCostPlan() != null) {
            vo.setCostPlanName(vo.getCostPlan() == 0 ? "取消勾选" : "勾选");
        }
        if (vo.getSubjectDist() != null) {
            vo.setSubjectDistName(vo.getSubjectDist() == 0 ? "取消勾选" : "勾选");
        }


    }

    /**
     * 核对提交数据
     *
     * @param payload
     */
    void checkWbsData(PmsProjectWbsDataPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "归属项目不存在，请核验！");
        }

    }


}
