package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsActCostQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsWbsActCostService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActCostConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActCostDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsActCostRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * wbs活动成预估
 *
 * @author carl
 * @date 2023-04-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsWbsActCostServiceImpl extends BaseServiceImpl implements PmsWbsActCostService {

    private final PmsWbsActCostRepo pmsWbsActCostRepo;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;

    @Override
    public PagingVO<PmsWbsActCostVO> paging(PmsWbsActCostQuery query) {
        Page<PmsWbsActCostDO> page = pmsWbsActCostRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PmsWbsActCostConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<PmsWbsActCostVO> queryPaging(PmsWbsActCostQuery query) {
        return pmsWbsActCostDAO.queryPaging(query);
    }

    @Override
    public List<PmsWbsActCostVO> queryList(PmsWbsActCostQuery query) {
        return PmsWbsActCostConvert.INSTANCE.toVoList(
                pmsWbsActCostRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<PmsWbsActCostVO> queryListDynamic(PmsWbsActCostQuery query) {
        return pmsWbsActCostDAO.queryListDynamic(query);
    }

    @Override
    public PmsWbsActCostVO queryByKey(Long key) {
        PmsWbsActCostDO entity = pmsWbsActCostRepo.findById(key).orElseGet(PmsWbsActCostDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsActCostVO vo = PmsWbsActCostConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsActCostVO insert(PmsWbsActCostPayload payload) {
        PmsWbsActCostDO entityDo = PmsWbsActCostConvert.INSTANCE.toDo(payload);
        return PmsWbsActCostConvert.INSTANCE.toVo(pmsWbsActCostRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsActCostVO update(PmsWbsActCostPayload payload) {
        PmsWbsActCostDO entity = pmsWbsActCostRepo.findById(payload.getId()).orElseGet(PmsWbsActCostDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsActCostDO entityDo = PmsWbsActCostConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsWbsActCostConvert.INSTANCE.toVo(pmsWbsActCostRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<PmsWbsActCostDO> optional = pmsWbsActCostRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsWbsActCostDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    pmsWbsActCostRepo.save(entity);
                }
            });
        }
    }

}
