package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsTemplateNodePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsTemplateNodeQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsWbsTemplateNodeService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsTemplateNodeVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsTemplateNodeConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsTemplateNodeDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsTemplateNodeDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsTemplateNodeRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

/**
 * wbs模板节点
 *
 * @author Echo
 * @date 2023-03-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsWbsTemplateNodeServiceImpl extends BaseServiceImpl implements PmsWbsTemplateNodeService {

    private final PmsWbsTemplateNodeRepo pmsWbsTemplateNodeRepo;
    private final PmsWbsTemplateNodeDAO pmsWbsTemplateNodeDAO;

    @Override
    public PagingVO<PmsWbsTemplateNodeVO> paging(PmsWbsTemplateNodeQuery query){
        Page<PmsWbsTemplateNodeDO> page = pmsWbsTemplateNodeRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(PmsWbsTemplateNodeConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<PmsWbsTemplateNodeVO> queryPaging(PmsWbsTemplateNodeQuery query){
        return pmsWbsTemplateNodeDAO.queryPaging(query);
    }

    @Override
    public List<PmsWbsTemplateNodeVO> queryList(PmsWbsTemplateNodeQuery query){
        return PmsWbsTemplateNodeConvert.INSTANCE.toVoList(
                pmsWbsTemplateNodeRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
             )
        );
    }

    @Override
    public List<PmsWbsTemplateNodeVO> queryListDynamic(PmsWbsTemplateNodeQuery query){
        return pmsWbsTemplateNodeDAO.queryListDynamic(query);
    }

    @Override
    public PmsWbsTemplateNodeVO queryByKey(Long key) {
        PmsWbsTemplateNodeDO entity = pmsWbsTemplateNodeRepo.findById(key).orElseGet(PmsWbsTemplateNodeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsTemplateNodeVO vo = PmsWbsTemplateNodeConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsTemplateNodeVO insert(PmsWbsTemplateNodePayload payload) {
        PmsWbsTemplateNodeDO entityDo = PmsWbsTemplateNodeConvert.INSTANCE.toDo(payload);
        return PmsWbsTemplateNodeConvert.INSTANCE.toVo(pmsWbsTemplateNodeRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsTemplateNodeVO update(PmsWbsTemplateNodePayload payload) {
        PmsWbsTemplateNodeDO entity = pmsWbsTemplateNodeRepo.findById(payload.getId()).orElseGet(PmsWbsTemplateNodeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsTemplateNodeDO entityDo = PmsWbsTemplateNodeConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsWbsTemplateNodeConvert.INSTANCE.toVo(pmsWbsTemplateNodeRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<PmsWbsTemplateNodeDO> optional = pmsWbsTemplateNodeRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsWbsTemplateNodeDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    pmsWbsTemplateNodeRepo.save(entity);
                }
             });
        }
    }


    /**
     * 校验数据，必要字段不能为空
     *
     * @param payload
     */
    void checkData(PmsWbsTemplateNodePayload payload) {
        if (ObjectUtils.isEmpty(payload.getWbsName())){
            throw TwException.error("", "请完善标 * 的相关信息");
        }
    }

}
