package com.elitesland.tw.tw5pms.server.workflow;

import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;

/**
 * @author carl
 * @date 2023/03/29
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PMS_PROJECT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PmsProjectCallBackController implements WorkflowCallBack {
    private final PmsProjectDAO pmsProjectDAO;

    /**
     * 动态指定任务负责人
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    @Transactional()
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectPayload PmsProjectPayload = new PmsProjectPayload();
        PmsProjectPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象

        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(Long.valueOf(businessKey));

        if (pmsProjectVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    PmsProjectPayload.setProjectStatus(ProjectStatusEnum.CREATE.getCode());
                    PmsProjectPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    PmsProjectPayload.setProjectStatus(ProjectStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    PmsProjectPayload.setProjectStatus(ProjectStatusEnum.TERMINATED.getCode());
                    PmsProjectPayload.setDeleteFlag(1);
                    PmsProjectPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    PmsProjectPayload.setProjectStatus(ProjectStatusEnum.APPROVING_EJECTED.getCode());
                    PmsProjectPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    PmsProjectPayload.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
                    PmsProjectPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    PmsProjectPayload.setApprovedTime(LocalDateTime.now());

                    break;
                case APPROVING:
                    break;
            }
            pmsProjectDAO.updateWorkFlow(PmsProjectPayload);
        }
    }

}
