/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessDistributorInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessDistributorInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.identity.convert.BusinessDistributorInfoConvert;
import com.elitesland.tw.tw5.server.partner.identity.dao.BusinessDistributorInfoDAO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessDistributorInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceDetailService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceDetailVO;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BusinessDistributorInfoServiceImpl
extends BaseServiceImpl
implements BusinessDistributorInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessDistributorInfoServiceImpl.class);
    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    private final BusinessDistributorInfoDAO businessDistributorInfoDAO;
    private final FileUtil fileUtil;
    private final ProductPriceDetailService productPriceDetailService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;

    public PagingVO<BusinessDistributorInfoVO> queryPaging(BusinessDistributorInfoQuery query) {
        return this.businessDistributorInfoDAO.queryPaging(query);
    }

    public List<BusinessDistributorInfoVO> queryListDynamic(BusinessDistributorInfoQuery query) {
        List<BusinessDistributorInfoVO> businessDistributorInfoVOS = this.businessDistributorInfoDAO.queryListDynamic(query);
        businessDistributorInfoVOS.stream().forEach(vo -> {
            vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
            vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
            vo.setAuthProductDesc(this.translateAuthProduct(vo.getAuthProduct()));
        });
        return businessDistributorInfoVOS;
    }

    public BusinessDistributorInfoVO queryByKey(Long key) {
        BusinessDistributorInfoDO entity = this.businessDistributorInfoRepo.findById(key).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessDistributorInfoVO vo = BusinessDistributorInfoConvert.INSTANCE.toVo(entity);
        vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        vo.setAuthProductDesc(this.translateAuthProduct(vo.getAuthProduct()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDistributorInfoVO insert(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        return BusinessDistributorInfoConvert.INSTANCE.toVo((BusinessDistributorInfoDO)this.businessDistributorInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDistributorInfoVO update(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entity = this.businessDistributorInfoRepo.findById(payload.getId()).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessDistributorInfoDO entityLog = new BusinessDistributorInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            String productLog = null;
            if (payload.getAuthProduct() != null) {
                productLog = "\u6388\u6743\u4ea7\u54c1\u7531" + this.translateAuthProduct(entityLog.getAuthProduct()) + " \u4fee\u6539\u4e3a " + this.translateAuthProduct(payload.getAuthProduct()) + "\n";
            }
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(productLog + this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessDistributorInfoConvert.INSTANCE.toVo((BusinessDistributorInfoDO)this.businessDistributorInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessDistributorInfoRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessDistributorInfoDO entity = (BusinessDistributorInfoDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessDistributorInfoRepo.save(entity);
                }
            });
        }
    }

    public String translateAuthProduct(String authProduct) {
        List skuIdList;
        List productPriceDetailVOS;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)authProduct) && (productPriceDetailVOS = this.productPriceDetailService.queryListBySkuIds(skuIdList = Arrays.stream(authProduct.split(",")).map(skuId -> Long.valueOf(skuId)).collect(Collectors.toList()))) != null && productPriceDetailVOS.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < productPriceDetailVOS.size(); ++i) {
                if (i == productPriceDetailVOS.size() - 1) {
                    stringBuilder.append(((ProductPriceDetailVO)productPriceDetailVOS.get(i)).getSkuName());
                    continue;
                }
                stringBuilder.append(((ProductPriceDetailVO)productPriceDetailVOS.get(i)).getSkuName() + ",");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public BusinessDistributorInfoServiceImpl(BusinessDistributorInfoRepo businessDistributorInfoRepo, BusinessDistributorInfoDAO businessDistributorInfoDAO, FileUtil fileUtil, ProductPriceDetailService productPriceDetailService, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService) {
        this.businessDistributorInfoRepo = businessDistributorInfoRepo;
        this.businessDistributorInfoDAO = businessDistributorInfoDAO;
        this.fileUtil = fileUtil;
        this.productPriceDetailService = productPriceDetailService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
    }
}

