/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationChanceDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationChanceRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class CrmCustomerOperationChanceDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerOperationChanceRepo repo;
    private final QCrmCustomerOperationChanceDO qdo = QCrmCustomerOperationChanceDO.crmCustomerOperationChanceDO;
    private final QCrmCustomerOperationDO qdoOperation = QCrmCustomerOperationDO.crmCustomerOperationDO;

    private JPAQuery<CrmCustomerOperationChanceVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerOperationChanceVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.operId, this.qdo.title, this.qdo.tags, this.qdo.trackerUserId, this.qdo.isRead, this.qdo.informUserIds, this.qdo.involvedUserIds, this.qdo.expectYear, this.qdo.expectQuarter, this.qdo.expectTime, this.qdo.chanceContent, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdoOperation.custName, this.qdoOperation.custOperBu, this.qdoOperation.custOperManagerId, this.qdoOperation.saleOperBu, this.qdoOperation.saleOperManagerId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoOperation)).on((Predicate)this.qdo.operId.eq(this.qdoOperation.id));
        return jpaQuery;
    }

    public CrmCustomerOperationChanceVO queryByKey(Long id) {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.eq((Object)id));
        return (CrmCustomerOperationChanceVO)jpaQuerySelect.fetchFirst();
    }

    public long update(CrmCustomerOperationChancePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (StringUtils.hasText((String)payload.getTitle())) {
            update.set((Path)this.qdo.title, (Object)payload.getTitle());
        }
        if (payload.getTrackerUserId() != null) {
            update.set(this.qdo.trackerUserId, (Object)payload.getTrackerUserId());
        }
        if (StringUtils.hasText((String)payload.getTags())) {
            update.set((Path)this.qdo.tags, (Object)payload.getTags());
        }
        if (StringUtils.hasText((String)payload.getRemark())) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (StringUtils.hasText((String)payload.getInvolvedUserIds())) {
            update.set((Path)this.qdo.involvedUserIds, (Object)payload.getInvolvedUserIds());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("trackerUserId")) {
                update.setNull(this.qdo.trackerUserId);
            }
            if (nullFields.contains("tags")) {
                update.setNull((Path)this.qdo.tags);
            }
            if (nullFields.contains("tags")) {
                update.setNull((Path)this.qdo.tags);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
            if (nullFields.contains("involvedUserIds")) {
                update.setNull((Path)this.qdo.involvedUserIds);
            }
        }
        return update.execute();
    }

    public List<CrmCustomerOperationChanceVO> queryList(Long operId) {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.operId.eq((Object)operId));
        return jpaQuerySelect.fetch();
    }

    public PagingVO<CrmCustomerOperationChanceVO> paging(CrmCustomerOperationChanceQuery query) {
        ArrayList<BooleanExpression> list;
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdoOperation.deleteFlag.eq((Object)0));
        if (query.getOperId() != null) {
            jpaQuerySelect.where((Predicate)this.qdo.operId.eq((Object)query.getOperId()));
        }
        if (StringUtils.hasText((String)query.getTitle())) {
            jpaQuerySelect.where((Predicate)this.qdo.title.like(SqlUtil.toSqlLikeString((String)query.getTitle())));
        }
        if (StringUtils.hasText((String)query.getCustName())) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.custName.like(SqlUtil.toSqlLikeString((String)query.getCustName())));
        }
        if (query.getTrackerUserId() != null) {
            jpaQuerySelect.where((Predicate)this.qdo.trackerUserId.eq((Object)query.getTrackerUserId()));
        }
        if (query.getIsRead() != null) {
            jpaQuerySelect.where((Predicate)this.qdo.isRead.eq((Object)query.getIsRead()));
        }
        if (StringUtils.hasText((String)query.getInformUserIds())) {
            list = new ArrayList<BooleanExpression>();
            for (String informUserId : query.getInformUserIds().split(",")) {
                list.add(this.qdo.informUserIds.contains(informUserId));
            }
            jpaQuerySelect.where(ExpressionUtils.anyOf(list));
        }
        if (StringUtils.hasText((String)query.getInvolvedUserIds())) {
            list = new ArrayList();
            for (String involvedUserId : query.getInvolvedUserIds().split(",")) {
                list.add(this.qdo.involvedUserIds.contains(involvedUserId));
            }
            jpaQuerySelect.where(ExpressionUtils.anyOf(list));
        }
        if (query.getExpectYear() != null) {
            jpaQuerySelect.where((Predicate)this.qdo.expectYear.eq((Object)query.getExpectYear()));
        }
        if (query.getExpectQuarter() != null) {
            jpaQuerySelect.where((Predicate)this.qdo.expectQuarter.eq((Object)query.getExpectQuarter()));
        }
        if (query.getCustOperBu() != null) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.custOperBu.eq((Object)query.getCustOperBu()));
        }
        if (query.getCustOperManagerId() != null) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.custOperManagerId.eq((Object)query.getCustOperManagerId()));
        }
        if (query.getSaleOperBu() != null) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.saleOperBu.eq((Object)query.getSaleOperBu()));
        }
        if (query.getSaleOperManagerId() != null) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.saleOperManagerId.eq((Object)query.getSaleOperManagerId()));
        }
        if (!query.getNoPermissionFlag().booleanValue()) {
            BooleanExpression jpaQueryOr = this.qdo.createUserId.eq((Object)query.getCreateUserId()).or((Predicate)this.qdo.trackerUserId.eq((Object)query.getCreateUserId())).or((Predicate)this.qdo.informUserIds.like(SqlUtil.toSqlLikeString((String)("" + query.getCreateUserId())))).or((Predicate)this.qdo.involvedUserIds.like(SqlUtil.toSqlLikeString((String)("" + query.getCreateUserId()))));
            if (!ObjectUtils.isEmpty((Object)query.getOperationIds())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdoOperation.id.in((Collection)query.getOperationIds()));
            }
            jpaQuerySelect.where((Predicate)jpaQueryOr);
        }
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuerySelect.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public void deleteByIdIn(List<Long> keys) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)where, (QBaseModel)this.qdo._super);
        where.execute();
    }

    public void deleteSoftByOperIds(List<Long> operIds) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.operId.in(operIds)});
        where.execute();
    }

    public CrmCustomerOperationChanceDAO(JPAQueryFactory jpaQueryFactory, CrmCustomerOperationChanceRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

