/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsCustomerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsCustomerRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmLeadsCustomerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmLeadsCustomerRepo repo;
    private final QCrmLeadsCustomerDO qdo = QCrmLeadsCustomerDO.crmLeadsCustomerDO;

    public CrmLeadsCustomerDO save(CrmLeadsCustomerDO ado) {
        return (CrmLeadsCustomerDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmLeadsCustomerDO> saveAll(List<CrmLeadsCustomerDO> dos) {
        return this.repo.saveAll(dos);
    }

    public CrmLeadsCustomerVO queryByKey(Long id) {
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (CrmLeadsCustomerVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<CrmLeadsCustomerVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmLeadsCustomerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerName, this.qdo.customerIndustry, this.qdo.customerContacts, this.qdo.contactsDepartment, this.qdo.contactsPosition, this.qdo.contactsPhone})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    private JPAQuery<CrmLeadsCustomerVO> getJpaQueryWhere(CrmLeadsCustomerQuery query) {
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            jpaQuery.where((Predicate)this.qdo.customerName.like(SqlUtil.toSqlLikeString((String)query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
            jpaQuery.where((Predicate)this.qdo.customerIndustry.eq((Object)query.getCustomerIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsDepartment())) {
            jpaQuery.where((Predicate)this.qdo.contactsDepartment.eq((Object)query.getContactsDepartment()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerContacts())) {
            jpaQuery.where((Predicate)this.qdo.customerContacts.like(SqlUtil.toSqlLikeString((String)query.getCustomerContacts())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPosition())) {
            jpaQuery.where((Predicate)this.qdo.contactsPosition.like(SqlUtil.toSqlLikeString((String)query.getContactsPosition())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPhone())) {
            jpaQuery.where((Predicate)this.qdo.contactsPhone.like(SqlUtil.toSqlLikeString((String)query.getContactsPhone())));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public List<CrmLeadsCustomerVO> queryListDynamic(CrmLeadsCustomerQuery query) {
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CrmLeadsCustomerVO> queryPaging(CrmLeadsCustomerQuery query) {
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public long updateByKeyDynamic(CrmLeadsCustomerPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getCustomerName() != null) {
            update.set((Path)this.qdo.customerName, (Object)payload.getCustomerName());
        }
        if (payload.getCustomerIndustry() != null) {
            update.set((Path)this.qdo.customerIndustry, (Object)payload.getCustomerIndustry());
        }
        if (payload.getCustomerContacts() != null) {
            update.set((Path)this.qdo.customerContacts, (Object)payload.getCustomerContacts());
        }
        if (payload.getContactsDepartment() != null) {
            update.set((Path)this.qdo.contactsDepartment, (Object)payload.getContactsDepartment());
        }
        if (payload.getContactsPosition() != null) {
            update.set((Path)this.qdo.contactsPosition, (Object)payload.getContactsPosition());
        }
        if (payload.getContactsPhone() != null) {
            update.set((Path)this.qdo.contactsPhone, (Object)payload.getContactsPhone());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("customerIndustry")) {
                update.setNull((Path)this.qdo.customerIndustry);
            }
            if (nullFields.contains("contactsDepartment")) {
                update.setNull((Path)this.qdo.contactsDepartment);
            }
            if (nullFields.contains("contactsPosition")) {
                update.setNull((Path)this.qdo.contactsPosition);
            }
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public CrmLeadsCustomerDAO(JPAQueryFactory jpaQueryFactory, CrmLeadsCustomerRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

