/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationChanceService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationChanceConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationChanceDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationChanceRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmCustomerOperationChanceServiceImpl
implements CrmCustomerOperationChanceService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerOperationChanceServiceImpl.class);
    private final CrmCustomerOperationChanceRepo repo;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmCustomerOperationChanceDAO dao;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final CrmCustomerOperationRepo repoCustomerOperation;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final CrmPeopleService peopleService;
    private final CrmCustomerOperationRepo customerOperationRepo;

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationChanceVO insertOrUpdate(CrmCustomerOperationChancePayload payload) {
        this.check(payload);
        CrmCustomerOperationChanceDO entityDo = CrmCustomerOperationChanceConvert.INSTANCE.toDo(payload);
        String firstName = GlobalUtil.getLoginUser().getFirstName();
        String name = PrdSystemLogEnum.CREATE.getDesc();
        if (payload.getId() == null) {
            entityDo.setIsRead(0);
            entityDo = (CrmCustomerOperationChanceDO)((Object)this.repo.save((Object)entityDo));
            this.sendQwxMessage(entityDo, null, firstName);
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), "(" + firstName + ")" + name + PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getDesc());
        } else {
            name = PrdSystemLogEnum.UPDATE.getDesc();
            Optional chanceDO = this.repo.findById(payload.getId());
            if (chanceDO.isPresent()) {
                CrmCustomerOperationChanceDO crmCustomerOperationChanceDO = (CrmCustomerOperationChanceDO)((Object)chanceDO.get());
                entityDo.setInvolvedUserIds(crmCustomerOperationChanceDO.getInvolvedUserIds());
                if (crmCustomerOperationChanceDO.getTrackerUserId() == null) {
                    entityDo.setIsRead(0);
                } else if (entityDo.getTrackerUserId() != null && !entityDo.getTrackerUserId().equals(crmCustomerOperationChanceDO.getTrackerUserId())) {
                    entityDo.setIsRead(0);
                }
                CrmCustomerOperationChanceDO entityLog = new CrmCustomerOperationChanceDO();
                BeanUtils.copyProperties((Object)((Object)crmCustomerOperationChanceDO), (Object)((Object)entityLog));
                crmCustomerOperationChanceDO.copy(entityDo);
                StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, crmCustomerOperationChanceDO);
                this.repo.save((Object)crmCustomerOperationChanceDO);
                fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
                if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                    this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), fieldsUpdateLog.toString());
                }
                this.sendQwxMessage(entityDo, entityLog, firstName);
            } else {
                throw TwException.error((String)"", (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        this.logService.saveNewLog(entityDo.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), name + PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getDesc());
        return CrmCustomerOperationChanceConvert.INSTANCE.toVo(entityDo);
    }

    void sendQwxMessage(CrmCustomerOperationChanceDO newDo, CrmCustomerOperationChanceDO oldDo, String firstName) {
        if (StringUtils.hasText((String)newDo.getInformUserIds())) {
            if (oldDo == null || !StringUtils.hasText((String)oldDo.getInformUserIds())) {
                CrmCustomerOperationDO entity = this.repoCustomerOperation.findById(newDo.getOperId()).orElseGet(CrmCustomerOperationDO::new);
                Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                String[] split = newDo.getInformUserIds().split(",");
                List informUserIds = Arrays.asList(split).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
                String content = firstName + "\u5728\u201c" + entity.getCustName() + "--" + newDo.getTitle() + "\u201c\u77e5\u4f1a\u4e86\u4f60";
                this.qyWxCommunicationService.sendMessageToUser(informUserIds, content);
            } else if (!newDo.getInformUserIds().equals(oldDo.getInformUserIds())) {
                ArrayList<Long> informUserIds = new ArrayList<Long>();
                String[] split = newDo.getInformUserIds().split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (oldDo.getInformUserIds().contains(split[i])) continue;
                    informUserIds.add(Long.valueOf(split[i].trim()));
                }
                if (informUserIds.size() > 0) {
                    CrmCustomerOperationDO entity = this.repoCustomerOperation.findById(newDo.getOperId()).orElseGet(CrmCustomerOperationDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    String content = firstName + "\u5728\u201c" + entity.getCustName() + "--" + newDo.getTitle() + "\u201c\u77e5\u4f1a\u4e86\u4f60";
                    this.qyWxCommunicationService.sendMessageToUser(informUserIds, content);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationChanceVO queryByKey(Long key) {
        Optional operOptional;
        CrmCustomerOperationChanceVO crmCustomerOperationChanceVO = this.dao.queryByKey(key);
        this.transferData(crmCustomerOperationChanceVO);
        if (crmCustomerOperationChanceVO.getTrackerUserId() != null && GlobalUtil.getLoginUserId().compareTo(crmCustomerOperationChanceVO.getTrackerUserId()) == 0 && crmCustomerOperationChanceVO.getIsRead() == 0) {
            this.repo.updateIsRead(GlobalUtil.getLoginUserId(), List.of(crmCustomerOperationChanceVO.getId()));
        }
        if (crmCustomerOperationChanceVO.getOperId() != null && (operOptional = this.customerOperationRepo.findById(crmCustomerOperationChanceVO.getOperId())).isPresent()) {
            crmCustomerOperationChanceVO.setCustOperStatus(((CrmCustomerOperationDO)((Object)operOptional.get())).getCustOperStatus());
        }
        return crmCustomerOperationChanceVO;
    }

    public List<CrmCustomerOperationChanceVO> queryList(Long operId) {
        if (ObjectUtils.isEmpty((Object)operId)) {
            throw TwException.error((String)"", (String)"operId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CrmCustomerOperationChanceVO> operationChanceVOS = this.dao.queryList(operId);
        operationChanceVOS.forEach(operationChanceVO -> this.transferData((CrmCustomerOperationChanceVO)operationChanceVO));
        return operationChanceVOS;
    }

    public PagingVO<CrmCustomerOperationChanceVO> paging(CrmCustomerOperationChanceQuery query) {
        this.operPermissionFlag(query);
        PagingVO<CrmCustomerOperationChanceVO> paging = this.dao.paging(query);
        paging.getRecords().forEach(operationChanceVO -> {
            this.transferData((CrmCustomerOperationChanceVO)operationChanceVO);
            operationChanceVO.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.OPER_CHANCE.getCode(), operationChanceVO.getId())));
            operationChanceVO.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.OPER_CHANCE.getCode(), operationChanceVO.getId())));
        });
        return paging;
    }

    void operPermissionFlag(CrmCustomerOperationChanceQuery query) {
        Boolean rolePermission = false;
        rolePermission = query.getOperId() != null ? Boolean.valueOf(true) : this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        query.setNoPermissionFlag(rolePermission);
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserId(GlobalUtil.getLoginUserId());
            List operationIds = this.peopleService.queryPermitOperationIds(userId);
            query.setOperationIds(operationIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        this.dao.deleteByIdIn(keys);
    }

    public void deleteSoftByOperIds(List<Long> operIds) {
        this.dao.deleteSoftByOperIds(operIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateInvolvedUser(Long key, List<Long> userIds) {
        CrmCustomerOperationChanceVO crmCustomerOperationChanceVO = this.dao.queryByKey(key);
        String involvedUserIds = crmCustomerOperationChanceVO.getInvolvedUserIds();
        CrmCustomerOperationChancePayload payload = new CrmCustomerOperationChancePayload();
        payload.setId(crmCustomerOperationChanceVO.getId());
        Object name = "\u6dfb\u52a0\u4e86\u53c2\u4e0e\u8005\uff08";
        if (StringUtils.hasText((String)involvedUserIds)) {
            String[] split = involvedUserIds.split(",");
            Set oldUserIds = Arrays.asList(split).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toSet());
            boolean b = oldUserIds.containsAll(userIds);
            if (b) {
                name = "\u5220\u9664\u4e86\u53c2\u4e0e\u8005\uff08";
                oldUserIds.removeAll(userIds);
            } else {
                oldUserIds.addAll(userIds);
            }
            if (oldUserIds.size() > 0) {
                involvedUserIds = oldUserIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            } else {
                involvedUserIds = null;
                payload.setNullFields(List.of("involvedUserIds"));
            }
        } else {
            involvedUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        for (Long userId : userIds) {
            String userName = this.cacheUtil.getUserName(userId);
            name = (String)name + userName + ",";
        }
        name = ((String)name).substring(0, ((String)name).length() - 1) + "\uff09";
        payload.setInvolvedUserIds(involvedUserIds);
        this.dao.update(payload);
        this.logService.saveNewLog(key, PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), "(" + GlobalUtil.getLoginUser().getFirstName() + ")" + (String)name);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateIsRead(List<Long> keys) {
        this.repo.updateIsRead(GlobalUtil.getLoginUserId(), keys);
    }

    public List<PrdSystemLogVO> queryLogList(Long id) {
        return this.logService.queryLogList(id, PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode());
    }

    private void check(CrmCustomerOperationChancePayload payload) {
        if (null == payload.getOperId()) {
            throw TwException.error((String)"", (String)"operId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == payload.getTitle()) {
            throw TwException.error((String)"", (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    void transferData(CrmCustomerOperationChanceVO vo) {
        vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        if (vo.getTrackerUserId() != null) {
            vo.setTrackerUserName(this.cacheUtil.getUserName(vo.getTrackerUserId()));
        }
        ArrayList involvedUsers = new ArrayList();
        if (StringUtils.hasText((String)vo.getInvolvedUserIds())) {
            String[] split = vo.getInvolvedUserIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                Long userId = Long.valueOf(split[i]);
                String userName = this.cacheUtil.getUserName(userId);
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("userId", userId);
                user.put("userName", userName);
                involvedUsers.add(user);
            }
        }
        vo.setInvolvedUsers(involvedUsers);
        ArrayList informUsers = new ArrayList();
        if (StringUtils.hasText((String)vo.getInformUserIds())) {
            for (String str : vo.getInformUserIds().split(",")) {
                Long informUserId = Long.parseLong(str);
                String userName = this.cacheUtil.getUserName(informUserId);
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("userId", informUserId);
                user.put("userName", userName);
                informUsers.add(user);
            }
        }
        vo.setInformUsers(informUsers);
        if (StringUtils.hasText((String)vo.getTags())) {
            String[] tags;
            ArrayList tagsDesc = new ArrayList();
            for (String tag : tags = vo.getTags().split(",")) {
                List systemTags = this.cacheUtil.getSystemTag(Long.valueOf(Long.parseLong(tag)));
                tagsDesc.addAll(systemTags);
            }
            vo.setTagsDesc(tagsDesc);
        }
    }

    public CrmCustomerOperationChanceServiceImpl(CrmCustomerOperationChanceRepo repo, ChangeFieldLogUtil changeFieldLogUtil, CrmCustomerOperationChanceDAO dao, QyWxCommunicationService qyWxCommunicationService, PrdSystemLogService logService, CacheUtil cacheUtil, CrmCustomerOperationRepo repoCustomerOperation, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService, CrmPeopleService peopleService, CrmCustomerOperationRepo customerOperationRepo) {
        this.repo = repo;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.dao = dao;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.repoCustomerOperation = repoCustomerOperation;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.peopleService = peopleService;
        this.customerOperationRepo = customerOperationRepo;
    }
}

