/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingApplyPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingApplyQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingApplyService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingDetailService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractInvoiceService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractBillingApplyVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractBillingApplyStatusEnum;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractBillingApplyConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractBillingApplyDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractBillingApplyDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractBillingApplyRepo;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractBillingApplyServiceImpl
extends BaseServiceImpl
implements ContractBillingApplyService {
    private static final Logger log = LoggerFactory.getLogger(ContractBillingApplyServiceImpl.class);
    private final ContractBillingApplyRepo contractBillingApplyRepo;
    private final ContractBillingApplyDAO contractBillingApplyDAO;
    private final ContractBillingDetailService contractBillingDetailService;
    private final ContractInvoiceService contractInvoiceService;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final CrmCustomerService crmCustomerService;

    public PagingVO<ContractBillingApplyVO> queryPaging(ContractBillingApplyQuery query) {
        this.dataPermissionFlag(query);
        return this.contractBillingApplyDAO.queryPaging(query);
    }

    public List<ContractBillingApplyVO> queryListDynamic(ContractBillingApplyQuery query) {
        this.dataPermissionFlag(query);
        return this.contractBillingApplyDAO.queryListDynamic(query);
    }

    public ContractBillingApplyVO queryByKey(Long key) {
        ContractBillingApplyDO entity = this.contractBillingApplyRepo.findById(key).orElseGet(ContractBillingApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u53d1\u7968\u7533\u8bf7\u4e0d\u5b58\u5728");
        ContractBillingApplyVO vo = ContractBillingApplyConvert.INSTANCE.toVo(entity);
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        return vo;
    }

    public ContractBillingApplyVO queryBillingInfoById(Long key) {
        ContractBillingApplyVO contractBillingApplyVO = this.queryByKey(key);
        contractBillingApplyVO.setContractBillingDetailVOList(this.contractBillingDetailService.queryListByBillingId(contractBillingApplyVO.getId()));
        contractBillingApplyVO.setContractInvoiceVO(this.contractInvoiceService.queryInvoicetByBillingId(contractBillingApplyVO.getId()));
        return contractBillingApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractBillingApplyVO insert(ContractBillingApplyPayload payload) {
        if (payload.getContractBillingDetailPayloadList() == null || payload.getContractBillingDetailPayloadList().size() == 0) {
            throw TwException.error((String)"", (String)"\u5f00\u7968\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        payload.setBillingCode(this.getBillingCode());
        ContractInvoicePayload contractInvoicePayload = payload.getContractInvoicePayload();
        payload.setApplyUserId(GlobalUtil.getLoginUserId());
        payload.setApplyUserName(GlobalUtil.getLoginUserName());
        if (payload.getCustomerId() != null) {
            CrmCustomerSimpleVO customerVO = this.crmCustomerService.querySimpleByKey(payload.getCustomerId());
            Assert.notNull((Object)customerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            payload.setCustomerName(customerVO.getCustomerName());
        }
        payload.setBillingMainbody(contractInvoicePayload.getBillingMainbody());
        payload.setBillingStatus(ContractBillingApplyStatusEnum.BILLING.getCode());
        payload.setInvoiceTitle(contractInvoicePayload.getInvoiceTitle());
        ContractBillingApplyDO entityDo = ContractBillingApplyConvert.INSTANCE.toDo(payload);
        ContractBillingApplyVO contractBillingApplyVO = ContractBillingApplyConvert.INSTANCE.toVo((ContractBillingApplyDO)this.contractBillingApplyRepo.save(entityDo));
        List contractBillingDetailPayloadList = payload.getContractBillingDetailPayloadList();
        List contractBillingDetailVOList = this.contractBillingDetailService.saveAll(contractBillingDetailPayloadList, contractBillingApplyVO.getId().longValue(), contractBillingApplyVO.getBillingCode());
        contractInvoicePayload.setBillingId(contractBillingApplyVO.getId());
        contractInvoicePayload.setBillingCode(contractBillingApplyVO.getBillingCode());
        contractInvoicePayload.setCurrCode(contractBillingApplyVO.getCurrCode());
        ContractInvoiceVO contractInvoiceVO = this.contractInvoiceService.insert(contractInvoicePayload);
        contractBillingApplyVO.setContractBillingDetailVOList(contractBillingDetailVOList);
        contractBillingApplyVO.setContractInvoiceVO(contractInvoiceVO);
        return contractBillingApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractBillingApplyVO update(ContractBillingApplyPayload payload) {
        ContractBillingApplyDO entity = this.contractBillingApplyRepo.findById(payload.getId()).orElseGet(ContractBillingApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u53d1\u7968\u7533\u8bf7\u4e0d\u5b58\u5728");
        ContractBillingApplyDO entityDo = ContractBillingApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractBillingApplyConvert.INSTANCE.toVo((ContractBillingApplyDO)this.contractBillingApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractBillingApplyRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractBillingApplyDO entity = (ContractBillingApplyDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractBillingApplyRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void invoiceEntry(ContractBillingApplyPayload payload) {
        ContractBillingApplyDO entity = this.contractBillingApplyRepo.findById(payload.getId()).orElseGet(ContractBillingApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (!ContractBillingApplyStatusEnum.BILLING.getCode().equals(entity.getBillingStatus())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u5f00\u7968\u4e2d\u7684\u7533\u8bf7\u624d\u53ef\u4ee5\u5f55\u5165\u53d1\u7968,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        entity.setInvoiceTaxNum(payload.getInvoiceTaxNum());
        entity.setBillingStatus(ContractBillingApplyStatusEnum.INVOICED.getCode());
        entity.setInvoiceDate(LocalDate.now());
        this.contractBillingApplyRepo.save(entity);
        this.contractInvoiceService.updateInvoiceEntry(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancleInvoice(List<String> billingList) {
        if (!billingList.isEmpty()) {
            billingList.stream().forEach(id -> {
                Optional optional = this.contractBillingApplyRepo.findById(Long.valueOf(id));
                if (!optional.isEmpty()) {
                    ContractBillingApplyDO entity = (ContractBillingApplyDO)optional.get();
                    entity.setBillingStatus(ContractBillingApplyStatusEnum.VOIDED.getCode());
                    this.contractBillingApplyRepo.save(entity);
                }
            });
        }
    }

    public String getBillingCode() {
        return this.generateSeqNum("CRM_CONTRACT_BILLING_APPLY", new String[0]);
    }

    void dataPermissionFlag(ContractBillingApplyQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CONTRACT_ADMIN.getCode()));
        query.setDataPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(loginUserId);
        }
    }

    public ContractBillingApplyServiceImpl(ContractBillingApplyRepo contractBillingApplyRepo, ContractBillingApplyDAO contractBillingApplyDAO, ContractBillingDetailService contractBillingDetailService, ContractInvoiceService contractInvoiceService, CacheUtil cacheUtil, FileUtil fileUtil, CrmCustomerService crmCustomerService) {
        this.contractBillingApplyRepo = contractBillingApplyRepo;
        this.contractBillingApplyDAO = contractBillingApplyDAO;
        this.contractBillingDetailService = contractBillingDetailService;
        this.contractInvoiceService = contractInvoiceService;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.crmCustomerService = crmCustomerService;
    }
}

