/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractProductRefPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractProductRefQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractProductRefService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractProductRefVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractProductRefConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractProductRefDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractProductRefDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractProductRefRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractProductRefServiceImpl
extends BaseServiceImpl
implements ContractProductRefService {
    private static final Logger log = LoggerFactory.getLogger(ContractProductRefServiceImpl.class);
    private final ContractProductRefRepo contractProductRefRepo;
    private final ContractProductRefDAO contractProductRefDAO;

    public PagingVO<ContractProductRefVO> queryPaging(ContractProductRefQuery query) {
        return this.contractProductRefDAO.queryPaging(query);
    }

    public List<ContractProductRefVO> queryListDynamic(ContractProductRefQuery query) {
        return this.contractProductRefDAO.queryListDynamic(query);
    }

    public ContractProductRefVO queryByKey(Long key) {
        ContractProductRefDO entity = this.contractProductRefRepo.findById(key).orElseGet(ContractProductRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractProductRefVO vo = ContractProductRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractProductRefVO insert(ContractProductRefPayload payload) {
        ContractProductRefDO entityDo = ContractProductRefConvert.INSTANCE.toDo(payload);
        return ContractProductRefConvert.INSTANCE.toVo((ContractProductRefDO)this.contractProductRefRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractProductRefVO update(ContractProductRefPayload payload) {
        ContractProductRefDO entity = this.contractProductRefRepo.findById(payload.getId()).orElseGet(ContractProductRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractProductRefDO entityDo = ContractProductRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractProductRefConvert.INSTANCE.toVo((ContractProductRefDO)this.contractProductRefRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractProductRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractProductRefDO entity = (ContractProductRefDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractProductRefRepo.save(entity);
                }
            });
        }
    }

    public ContractProductRefServiceImpl(ContractProductRefRepo contractProductRefRepo, ContractProductRefDAO contractProductRefDAO) {
        this.contractProductRefRepo = contractProductRefRepo;
        this.contractProductRefDAO = contractProductRefDAO;
    }
}

