/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractTemplateOrgRefPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractTemplatePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractTemplateQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractTemplateOrgRefService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractTemplateService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractTemplateVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractTemplateStatusEnum;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractTemplateConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractTemplateDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractTemplateDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractTemplateRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractTemplateServiceImpl
extends BaseServiceImpl
implements ContractTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ContractTemplateServiceImpl.class);
    private final ContractTemplateRepo contractTemplateRepo;
    private final ContractTemplateDAO contractTemplateDAO;
    private final CacheUtil cacheUtil;
    public static final String ALL = "ALL";
    private final ContractTemplateOrgRefService contractTemplateOrgRefService;
    private final FileUtil fileUtil;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;
    private final ComBusinessChangeService businessChangeService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final WorkflowService workflowService;

    public PagingVO<ContractTemplateVO> queryPaging(ContractTemplateQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<ContractTemplateVO> contractTemplateVOPagingVO = this.contractTemplateDAO.queryPaging(query);
        List records = contractTemplateVOPagingVO.getRecords();
        this.getTaskInfo(records);
        return contractTemplateVOPagingVO;
    }

    public List<ContractTemplateVO> queryListDynamic(ContractTemplateQuery query) {
        this.dataPermissionFlag(query);
        List<ContractTemplateVO> records = this.contractTemplateDAO.queryListDynamic(query);
        return records;
    }

    private void getTaskInfo(List<ContractTemplateVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    void dataPermissionFlag(ContractTemplateQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CONTRACT_ADMIN.getCode()));
        query.setDataPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(loginUserId);
            query.setLoginOrgId(this.cacheUtil.getDefaultOrgIdByUserId(loginUserId));
        }
    }

    public ContractTemplateVO queryByKey(Long key) {
        ContractTemplateVO vo = this.contractTemplateDAO.queryByKey(key);
        Assert.notNull((Object)vo, (String)"\u5408\u540c\u6a21\u7248\u4e0d\u5b58\u5728");
        this.translation(vo);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            vo.setTaskInfo(taskInfo);
        }
        return vo;
    }

    private void translation(ContractTemplateVO vo) {
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractTemplateVO insert(ContractTemplatePayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        ContractTemplateDO entityDo = ContractTemplateConvert.INSTANCE.toDo(payload);
        ContractTemplateDO save = (ContractTemplateDO)this.contractTemplateRepo.save(entityDo);
        this.saveOrgRef(payload, save);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(save.getId());
            this.submitProc(payload);
        }
        return ContractTemplateConvert.INSTANCE.toVo(save);
    }

    private void saveOrgRef(ContractTemplatePayload payload, ContractTemplateDO save) {
        Long tempId = save.getId();
        this.contractTemplateOrgRefService.deleteByTempId(tempId);
        String orgIdList = payload.getOrgIdList();
        if (StringUtils.hasText((String)orgIdList) && !ALL.equals(orgIdList)) {
            String[] split;
            for (String orgId : split = orgIdList.split(",")) {
                Long orgIdLong = Long.valueOf(orgId);
                String orgName = this.cacheUtil.getOrgName(orgIdLong);
                ContractTemplateOrgRefPayload contractTemplateOrgRefPayload = new ContractTemplateOrgRefPayload(orgName, tempId, orgIdLong);
                this.contractTemplateOrgRefService.insert(contractTemplateOrgRefPayload);
            }
        }
    }

    private void check(ContractTemplatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getName())) {
            throw TwException.error((String)"", (String)"\u8bf7\u8f93\u5165\u6a21\u7248\u540d\u79f0");
        }
    }

    private void dataProcess(ContractTemplatePayload payload) {
        String orgIdList;
        if (null == payload.getId()) {
            if (ObjectUtils.isEmpty((Object)payload.getStatus())) {
                payload.setStatus(ContractTemplateStatusEnum.CREATE.getCode());
            }
            String code = this.generateSeqNum("CONTRACT_TEMPLATE", new String[0]);
            payload.setCode(code);
        }
        if (StringUtils.hasText((String)(orgIdList = payload.getOrgIdList())) && !ALL.equals(orgIdList)) {
            ArrayList<String> orgIdName = new ArrayList<String>();
            String[] split = orgIdList.split(",");
            ArrayList templateOrgRefPayloads = new ArrayList();
            for (String orgId : split) {
                Long orgIdLong = Long.valueOf(orgId);
                String orgName = this.cacheUtil.getOrgName(orgIdLong);
                orgIdName.add(orgName);
            }
            String orgIdNameStr = orgIdName.stream().collect(Collectors.joining(","));
            payload.setOrgNameList(orgIdNameStr);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractTemplateVO update(ContractTemplatePayload payload) {
        ContractTemplateDO entity = this.contractTemplateRepo.findById(payload.getId()).orElseGet(ContractTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u6a21\u7248\u4e0d\u5b58\u5728");
        this.check(payload);
        this.dataProcess(payload);
        ContractTemplateDO entityDo = ContractTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ContractTemplateDO save = (ContractTemplateDO)this.contractTemplateRepo.save(entity);
        this.saveOrgRef(payload, save);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(save.getId());
            this.submitProc(payload);
        }
        return ContractTemplateConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(ContractTemplatePayload payload) {
        ContractTemplatePayload update = new ContractTemplatePayload();
        update.setId(payload.getId());
        update.setStatus(payload.getStatus());
        return this.contractTemplateDAO.updateByKeyDynamic(update);
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractTemplateVO updateForFlow(ContractTemplatePayload payload) {
        ContractTemplateDO entity = this.contractTemplateRepo.findById(payload.getId()).orElseGet(ContractTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u6a21\u7248\u4e0d\u5b58\u5728");
        this.check(payload);
        this.dataProcess(payload);
        ContractTemplateDO entityDo = ContractTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ContractTemplateDO save = (ContractTemplateDO)this.contractTemplateRepo.save(entity);
        this.saveOrgRef(payload, save);
        return ContractTemplateConvert.INSTANCE.toVo(save);
    }

    void submitProc(ContractTemplatePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap batchMap = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CONTRACT_TEMPLATE.name(), (String)("\u5408\u540c\u6a21\u7248-" + payload.getName() + "-\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        if (Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        }
        ContractTemplatePayload payload0 = new ContractTemplatePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.contractTemplateDAO.updateWorkFlow(payload0));
    }

    @Transactional(rollbackFor={Exception.class})
    public Long change(ContractTemplatePayload payload) {
        ComBusinessChangeVO comBusinessChangeVO;
        if (payload.getId() == null) {
            throw TwException.error((String)"", (String)"\u83b7\u53d6id\u5931\u8d25");
        }
        if (payload.getStatus() == null || !payload.getStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u4ec5\u6fc0\u6d3b\u7684\u6570\u636e\u53ef\u4ee5\u7533\u8bf7\u53d8\u66f4");
        }
        ContractTemplateVO contractTemplateVO = this.contractTemplateDAO.queryByKey(payload.getId());
        Assert.notNull((Object)contractTemplateVO, (String)"\u5408\u540c\u6a21\u7248\u4e0d\u5b58\u5728");
        this.translation(contractTemplateVO);
        ContractTemplatePayload contractTemplatePayload = ContractTemplateConvert.INSTANCE.toPayload(contractTemplateVO);
        payload.setFileDatas(this.fileUtil.getFileDatas(payload.getFileCodes()));
        if (StringUtils.hasText((String)payload.getOrgIdList())) {
            String[] split = payload.getOrgIdList().split(",");
            ArrayList<String> orgNameList = new ArrayList<String>();
            for (String orgId : split) {
                orgNameList.add(this.cacheUtil.getOrgName(Long.valueOf(orgId)));
            }
            payload.setOrgNameList(orgNameList.stream().collect(Collectors.joining(",")));
        }
        Long saveId = this.businessChangeService.save(ChangeTypeEnum.CONTRACT_TEMPLATE.getCode(), this.udcUtil.translate((Object)contractTemplatePayload), this.udcUtil.translate((Object)payload), "" + payload.getId());
        ProcessInfo processInfo = new ProcessInfo();
        String apprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        String changeApprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        String changeStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            apprStatusTemp = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            changeApprStatusTemp = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            changeStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
            HashMap batchMap = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.TEMPLATE_CHANGE.name(), (String)("\u5408\u540c\u6a21\u7248-" + payload.getName() + "-\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        }
        ContractTemplatePayload payload0 = new ContractTemplatePayload();
        payload0.setId(payload.getId());
        payload0.setChangeId(saveId);
        payload0.setChangeSubmitTime(LocalDateTime.now());
        payload0.setChangeProcInstId(processInfo.getProcInstId());
        payload0.setChangeProcInstStatus(processInfo.getProcInstStatus());
        payload0.setStatus(apprStatusTemp);
        ComBusinessChangePayload businessChangePayload = new ComBusinessChangePayload();
        businessChangePayload.setId(saveId);
        businessChangePayload.setApprProcInstId(processInfo.getProcInstId());
        businessChangePayload.setApprStatus(changeApprStatusTemp);
        businessChangePayload.setProcInstId(processInfo.getProcInstId());
        businessChangePayload.setProcInstStatus(processInfo.getProcInstStatus());
        businessChangePayload.setChangeStatus(changeStatusTemp);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.contractTemplateDAO.updateChangeWorkFlow(payload0);
            this.businessChangeDao.updateWorkFlow(businessChangePayload);
        });
        if (!this.workflow_enabled.booleanValue() && (comBusinessChangeVO = this.businessChangeDao.queryByKey(saveId)) != null) {
            ContractTemplatePayload updatePayload = new ContractTemplatePayload();
            updatePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
            updatePayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            updatePayload = (ContractTemplatePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), ContractTemplatePayload.class);
            updatePayload.setApprovedTime(LocalDateTime.now());
            updatePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());
            ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
            changePayload.setId(comBusinessChangeVO.getId());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            this.businessChangeDao.updateWorkFlow(changePayload);
            this.updateForFlow(updatePayload);
        }
        return saveId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractTemplateRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractTemplateDO entity = (ContractTemplateDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractTemplateRepo.save(entity);
                }
            });
        }
    }

    public Long changeUpdate(ContractTemplatePayload payload) {
        payload.setFileDatas(this.fileUtil.getFileDatas(payload.getFileCodes()));
        Long changeId = this.businessChangeService.update(ChangeTypeEnum.CONTRACT_TEMPLATE.getCode(), "" + payload.getId(), this.udcUtil.translate((Object)payload));
        return changeId;
    }

    public ContractTemplateServiceImpl(ContractTemplateRepo contractTemplateRepo, ContractTemplateDAO contractTemplateDAO, CacheUtil cacheUtil, ContractTemplateOrgRefService contractTemplateOrgRefService, FileUtil fileUtil, WorkflowUtil workflowUtil, UdcUtil udcUtil, TransactionUtilService transactionUtilService, ComBusinessChangeService businessChangeService, ComBusinessChangeDAO businessChangeDao, WorkflowService workflowService) {
        this.contractTemplateRepo = contractTemplateRepo;
        this.contractTemplateDAO = contractTemplateDAO;
        this.cacheUtil = cacheUtil;
        this.contractTemplateOrgRefService = contractTemplateOrgRefService;
        this.fileUtil = fileUtil;
        this.workflowUtil = workflowUtil;
        this.udcUtil = udcUtil;
        this.transactionUtilService = transactionUtilService;
        this.businessChangeService = businessChangeService;
        this.businessChangeDao = businessChangeDao;
        this.workflowService = workflowService;
    }
}

