/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupDetailPayload;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupQuery;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessAttributeGroupService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupVO;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessAttributeGroupConvert;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessAttributeGroupDetailConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDetailDAO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDetailDO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmBusinessAttributeGroupServiceImpl
implements CrmBusinessAttributeGroupService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessAttributeGroupServiceImpl.class);
    private final CrmBusinessAttributeGroupDAO groupDAO;
    private final CrmBusinessAttributeGroupDetailDAO groupDetailDAO;

    public PagingVO<CrmBusinessAttributeGroupVO> paging(CrmBusinessAttributeGroupQuery query) {
        PagingVO<CrmBusinessAttributeGroupVO> crmBusinessAttributeGroupVOPagingVO = this.groupDAO.queryPaging(query);
        List records = crmBusinessAttributeGroupVOPagingVO.getRecords();
        List<Long> groupIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<CrmBusinessAttributeGroupDetailVO> detailsInfo = this.groupDetailDAO.queryByGroupId(groupIds);
        Map<Long, List<CrmBusinessAttributeGroupDetailVO>> detailsMap = detailsInfo.stream().collect(Collectors.groupingBy(CrmBusinessAttributeGroupDetailVO::getGroupId));
        records.forEach(e -> {
            if (detailsMap.get(e.getId()) != null) {
                List detailVOList = (List)detailsMap.get(e.getId());
                e.setDetail(detailVOList);
                String detailDesc = detailVOList.stream().map(CrmBusinessAttributeGroupDetailVO::getAttributeDesc).collect(Collectors.joining("\u3001"));
                e.setDetailDesc(detailDesc);
            }
            e.setStatusDesc(e.getStatus() == 0 ? "\u672a\u542f\u7528" : "\u5df2\u542f\u7528");
        });
        return crmBusinessAttributeGroupVOPagingVO;
    }

    public List<CrmBusinessAttributeGroupVO> queryList(CrmBusinessAttributeGroupQuery query) {
        return null;
    }

    public CrmBusinessAttributeGroupVO queryByKey(Long key) {
        CrmBusinessAttributeGroupVO vo = this.groupDAO.queryByKey(key);
        List<CrmBusinessAttributeGroupDetailVO> details = this.groupDetailDAO.queryByGroupId(key);
        vo.setDetail(details);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmBusinessAttributeGroupVO insert(CrmBusinessAttributeGroupPayload payload) {
        List detail = payload.getDetail();
        if (detail == null || detail.size() < 1) {
            throw new RuntimeException("\u5c5e\u6027\u7ec4\u5fc5\u987b\u8bbe\u7f6e\u660e\u7ec6\u5c5e\u6027");
        }
        payload.setStatus(Integer.valueOf(0));
        CrmBusinessAttributeGroupDO entityDo = CrmBusinessAttributeGroupConvert.INSTANCE.toDo(payload);
        CrmBusinessAttributeGroupDO save = this.groupDAO.save(entityDo);
        Long groupId = save.getId();
        this.insertDetail(payload, groupId);
        return CrmBusinessAttributeGroupConvert.INSTANCE.toVo(save);
    }

    private void insertDetail(CrmBusinessAttributeGroupPayload payload, Long groupId) {
        List detail = payload.getDetail();
        if (detail != null && detail.size() > 0) {
            for (CrmBusinessAttributeGroupDetailPayload detailPayload : detail) {
                CrmBusinessAttributeGroupDetailDO crmBusinessAttributeGroupDetailDO = CrmBusinessAttributeGroupDetailConvert.INSTANCE.toDo(detailPayload);
                crmBusinessAttributeGroupDetailDO.setGroupId(groupId);
                this.groupDetailDAO.save(crmBusinessAttributeGroupDetailDO);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmBusinessAttributeGroupVO update(CrmBusinessAttributeGroupPayload payload) {
        if (payload.getId() == null || payload.getId() < 0L) {
            throw new RuntimeException("\u83b7\u53d6id\u5f02\u5e38");
        }
        List detail = payload.getDetail();
        if (detail == null || detail.size() < 1) {
            throw new RuntimeException("\u5c5e\u6027\u7ec4\u5fc5\u987b\u8bbe\u7f6e\u660e\u7ec6\u5c5e\u6027");
        }
        this.groupDAO.updateByKeyDynamic(payload);
        this.groupDetailDAO.deleteByGroupId(payload.getId());
        this.insertDetail(payload, payload.getId());
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmBusinessAttributeGroupVO updateStatus(CrmBusinessAttributeGroupPayload payload) {
        if (payload.getId() == null || payload.getId() < 0L) {
            throw new RuntimeException("\u83b7\u53d6id\u5f02\u5e38");
        }
        this.groupDAO.updateByKeyDynamic(payload);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
    }

    public CrmBusinessAttributeGroupServiceImpl(CrmBusinessAttributeGroupDAO groupDAO, CrmBusinessAttributeGroupDetailDAO groupDetailDAO) {
        this.groupDAO = groupDAO;
        this.groupDetailDAO = groupDetailDAO;
    }
}

